###############################################################
# TkNet - Dialog Module
# Charlie KEMPSON - charlie@siren.demon.co.uk
# http://public.logica.com/~kempsonc/tknet.htm
# Version 1.1
###############################################################

###############################################################
#
#    Copyright (c) 1995-1996 Charlie Kempson
#
#    This program is free software; you can redistribute it 
#    and/or modify it under the terms of the GNU General 
#    Public License as published by the Free Software 
#    Foundation (version 2 of the License).
#
#    This program is distributed in the hope that it will 
#    be useful, but WITHOUT ANY WARRANTY; without even the 
#    implied warranty of MERCHANTABILITY or FITNESS FOR A 
#    PARTICULAR PURPOSE.  See the GNU General Public License 
#    for more details.
#
#    For a copy of the GNU General Public License, write to the 
#    Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
#    MA 02139, USA.
###############################################################

###############################################################
# Globals for this module
set BITMAP_HEIGHT       60
set BITMAP_WIDTH        40

# Flags

###############################################################
# Display a blocking information dialog
proc Info_Dialog { parent string } {

   # Globals
   global FONT_NORMAL RIDGE_BORDER DEFAULT_PADDING \
      BITMAP_HEIGHT BITMAP_WIDTH

   # Display the string to the user
   if [winfo exists .dialog] return
   toplevel .dialog
   wm title .dialog [wm title $parent]
   wm transient .dialog .
#   wm resizable .dialog 0 0 
   grab current .dialog

   ###############################################################
   # Create the message
   frame .dialog.fr -borderwidth $RIDGE_BORDER -relief groove
   pack .dialog.fr -padx $DEFAULT_PADDING -pady \
      $DEFAULT_PADDING -side top -expand true -fill both
   label .dialog.fr.bitmap -bitmap info -height \
      $BITMAP_HEIGHT -width $BITMAP_WIDTH
   label .dialog.fr.message -text $string -justify left
   pack .dialog.fr.bitmap .dialog.fr.message -side left \
      -anchor w

   ###############################################################
   # Create the buttons below the frame
   frame .dialog.button_frame -borderwidth $DEFAULT_PADDING
   pack .dialog.button_frame -side bottom -fill x
   button .dialog.button_frame.dismiss \
       -text Dismiss -command { destroy .dialog }
   pack .dialog.button_frame.dismiss

   
   ###############################################################
   # Bind return and space to dismiss
   bind .dialog <Return> {destroy .dialog}
   bind .dialog <space> {destroy .dialog}

   ###############################################################
   # Centre the dialog on the parent (was widget $parent)
   Centre_Dialog .dialog

   ###############################################################
   # Wait for the button to be pressed
   tkwait window .dialog
}

###############################################################
# Display a blocking question dialog
proc Question_Dialog { parent string button1 button2 } {

   # Globals
   global FONT_NORMAL RIDGE_BORDER DEFAULT_PADDING \
      BITMAP_HEIGHT BITMAP_WIDTH g_status

   # Initialise return status
   set g_status -1

   # Display the string to the user
   if [winfo exists .dialog] {return $g_status}
   toplevel .dialog
   wm title .dialog [wm title $parent]
   wm transient .dialog .
#   wm resizable .dialog 0 0 
   grab current .dialog

   ###############################################################
   # Create the message
   frame .dialog.fr -borderwidth $RIDGE_BORDER -relief groove
   pack .dialog.fr -padx $DEFAULT_PADDING -pady \
      $DEFAULT_PADDING -side top -expand true -fill both
   label .dialog.fr.bitmap -bitmap questhead -height \
      $BITMAP_HEIGHT -width $BITMAP_WIDTH
   label .dialog.fr.message -text $string -justify left
   pack .dialog.fr.bitmap .dialog.fr.message -side left \
      -anchor w

   ###############################################################
   # Create the buttons below the frame
   frame .dialog.button_frame -borderwidth $DEFAULT_PADDING
   pack .dialog.button_frame -side bottom -fill x
   button .dialog.button_frame.ok \
      -text $button1 -command {destroy .dialog; set g_status 0}
   button .dialog.button_frame.cancel \
      -text $button2 -command {destroy .dialog; set g_status 1}
   pack .dialog.button_frame.ok .dialog.button_frame.cancel \
      -side right

   ###############################################################
   # Centre the dialog on the parent
   Centre_Dialog .dialog

   ###############################################################
   # Wait for the button to be pressed
   tkwait variable g_status
   return $g_status
}

###############################################################
# Display a blocking information dialog
proc Working_Dialog { parent string } {

   # Globals
   global FONT_NORMAL RIDGE_BORDER DEFAULT_PADDING \
      BITMAP_HEIGHT BITMAP_WIDTH

   # Display the string to the user
   if [winfo exists .working_dialog] return
   set window [toplevel .working_dialog]
   wm title $window [wm title $parent]
   wm transient $window .
#   wm resizable $window 0 0 
   grab current $window

   ###############################################################
   # Create the message
   frame $window.fr -borderwidth $RIDGE_BORDER -relief groove
   pack $window.fr -padx $DEFAULT_PADDING -pady \
      $DEFAULT_PADDING -side top -expand true -fill both
   label $window.fr.bitmap -bitmap hourglass -height \
      $BITMAP_HEIGHT -width $BITMAP_WIDTH
   label $window.fr.message -text $string -justify left
   pack $window.fr.bitmap $window.fr.message -side left \
      -anchor w

   ###############################################################
   # Centre the dialog on the parent (was widget $parent)
   Centre_Dialog $window
   update
}

###############################################################
# Centre a window on the screen (or parent)
proc Centre_Dialog {window {position ""} {parent ""}} {

   # Withdraw dialog and update all windows
   wm withdraw $window
   update idletasks
   set win_width [winfo reqwidth $window]
   set win_height [winfo reqheight $window]

   # Read the positioning argument (pointer, widget, default)
   switch -glob -- $position {
      p* {
         # place at POINTER (centered is $a == center)
         wm geometry $window +[expr \
            [winfo pointerx $window]-$win_width \
            /2]+[expr [winfo pointery $window]-\
            $win_height/2]
      }
      w* {
         # center about WIDGET $parent
         wm geometry $window +[expr [winfo rootx $parent]+ \
            ([winfo width $parent]-$win_width)/2]+[expr \
            [winfo rooty $parent]+([winfo height \
            $parent]-$win_height)/2]
      }
      default {
         wm geometry $window +[expr ([winfo screenwidth \
            $window]-$win_width) / 2]+[expr ([winfo screenheight \
            $window]- $win_height) / 2]
      }
   }

   # Now show the window
   wm deiconify $window
}
