###############################################################
# TkNet - Colour Module
# Charlie KEMPSON - charlie@siren.demon.co.uk
# http://public.logica.com/~kempsonc/tknet.htm
# Version 1.1
###############################################################

###############################################################
#
#    Copyright (c) 1995-1996 Charlie Kempson
#
#    This program is free software; you can redistribute it 
#    and/or modify it under the terms of the GNU General 
#    Public License as published by the Free Software 
#    Foundation (version 2 of the License).
#
#    This program is distributed in the hope that it will 
#    be useful, but WITHOUT ANY WARRANTY; without even the 
#    implied warranty of MERCHANTABILITY or FITNESS FOR A 
#    PARTICULAR PURPOSE.  See the GNU General Public License 
#    for more details.
#
#    For a copy of the GNU General Public License, write to the 
#    Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
#    MA 02139, USA.
###############################################################

###############################################################
# Globals for this module

# Geometry
set TKNET_COLOUR_GEOMETRY "+408+51"

###############################################################
# Routine to show window to set up scripts
proc Choose_Colour { entry } {
   Debug "Choose_Colour"

   # Globals
   global TKNET_COLOUR_GEOMETRY RIDGE_BORDER \
     DEFAULT_PADDING

   # Popup a selection window
   set window .colour_window
   if [winfo exists $window] {
       # Pop it up!
       wm deiconify $window
       raise $window
       Info_Dialog . "You can have at most one Colour Selection window
open at a time!"
       update
       return
   }

   # Otherwise create the window
   toplevel $window
   wm title $window "Select Colour"
   wm transient $window .
   wm geometry $window $TKNET_COLOUR_GEOMETRY

   # Create a frame containing a list and an entry field
   frame $window.sel_fr -borderwidth $RIDGE_BORDER -relief groove
   pack $window.sel_fr -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -side top -fill x
   label $window.sel_fr.label -text "Colour"
   entry $window.sel_fr.entry -width 10
   $window.sel_fr.entry configure -state disabled
   label $window.sel_fr.test -borderwidth $RIDGE_BORDER -relief groove \
      -text "     "
   pack $window.sel_fr.label $window.sel_fr.entry \
      $window.sel_fr.test -side left \
      -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING
   set list [ScrolledList $window.list_fr 0 20 browse 0]
   pack forget $window.list_fr
   pack $window.list_fr -side top -fill both \
      -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -expand true

   # Add bindings to the list.  Single click should copy the
   # entry into the selected area, double click should do that
   # and return.
   bind $list <ButtonRelease-1> "Select_Colour $window $list"
   bind $list <Double-ButtonRelease-1> "Select_Colour $window \
      $list; Return_Colour $window $entry"

   # And add buttons to the window
   set frame [frame $window.button_fr]
   pack $frame -side bottom -fill x
   button $frame.close -text Cancel -command "destroy $window"
   button $frame.ok -text OK -command "Select_Colour $window \
      $list; Return_Colour $window $entry"
   pack $frame.ok $frame.close -side right -padx $DEFAULT_PADDING -pady \
      $DEFAULT_PADDING

   # Refresh the listing
   Display_Colours $list

   # Get and display the currently selected colour
   $window.sel_fr.entry configure -state normal
   set colour [$entry get]
   if {[$entry get] != ""} {
     $window.sel_fr.entry insert end $colour
     $window.sel_fr.test configure -background $colour
   }
   $window.sel_fr.entry configure -state disabled
}

###############################################################
# Routine to display colours
proc Display_Colours { list } {
   Debug "Display_Colours"

   # Globals
   global g_rgb_file

   # Delete all items
   $list delete 0 end
 
   # Create list of all colours
   if [catch {set fd [open $g_rgb_file r]}] {
      Info_Dialog . "Unable to open RGB info file.
Check the location of this file in the
Environment Settings window."
   } else {
      # Pop-up a working dialogue while the colour
      # file is being read.
      Working_Dialog . "Please wait while the system colours are read..."
      set file [read $fd]
      regsub -all {[\ ]+} $file { } file
      set file [split $file "\n"]
      # Discard the header information on the first line
      set file [lreplace $file 0 0]
      foreach item $file {
         # Extract the colour information
         lappend items [string trimleft $item "\ \t\n01234568789"]
      }
      eval $list insert end $items
      close $fd
      # Delete the working dialog
      destroy .working_dialog
   }
}

###############################################################
# Routine to add a return the colour
proc Return_Colour { window entry } {
   Debug "Return_Colour"

   # Copy the selected text into the entry field on
   # the scripts setup window.  Check that the user
   # hasn't dismissed the script setup window, though!
   if [winfo exists $entry] {
      # Set text
      $entry configure -state normal
      $entry delete 0 end
      $entry insert end [$window.sel_fr.entry get]

      # Destroy the window
      after 300 "destroy $window"
   } else {
      Info_Dialog . "The calling window has been dismissed!"
   }
}

###############################################################
# Routine called when a colour is selected from the list
proc Select_Colour { window list } {
   Debug "Select_Colour"

   # Copy the selected item into the entry field
   $window.sel_fr.entry configure -state normal
   $window.sel_fr.entry delete 0 end
   set cur_sel [$list curselection]
   if {$cur_sel != ""} {
      set select [$list get $cur_sel]
      $window.sel_fr.entry insert end $select
      if [catch {$window.sel_fr.test configure -background \
         $select}] {
         Info_Dialog . "Unknown colour $select"
      }
   }
   $window.sel_fr.entry configure -state disabled
}

