/*
 * Xtmon 1.0 - Written by Liem Bahneman (roland@cac.washington..edu) 4/94
 * (C) 1994, Liem Bahneman 
 * 
 *   "This software product makes use of the Control Panel Widget Set (Xc),
 * v. 1.3, copyright 1992 by Paul D. Johnston."
 *
 * Original tmon.c code by Michael O'Reilly and John Hendrickson 
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for any purpose and without fee is granted
 * provided that the above copyright notice appears in all copies.
 * It is provided "as is" without express or implied waranty.
 *
 **********************************************
 */

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/times.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <ctype.h>
#include <signal.h>
#include <memory.h>

/* Xlib headers */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Form.h>

/* Control Panel Widget Set headers */
#include <X11/Xc/Xc.h>
#include <X11/Xc/SimpleB.h>
#include <X11/Xc/BarGraf.h>

/* term headers */
#include "includes.h"
#include "client.h"

#ifndef HZ
#define HZ 60
#endif

#define STAT(local, st) \
  if (send_command(s, C_STATS, local, "%d",st)< 0) { \
      fprintf(stderr,"C_STATS command failed. Abort.\n"); \
      exit(1); \
      }

/* Widget IDs */
Widget TopLevel, MainBox, Panel1, ButtonBox, IncomingCPS, OutgoingCPS;
Widget FooButton1;

/* Callback for the Quit button: simply quits the application. */
void Quit(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  XtDestroyWidget(TopLevel);
  exit(0);
}

XtWorkProc do_monitor()
{
  struct timeval timeout;
  int last_in, last_out, d1, d2, i, ihist[33],ohist[33];
  int scale=1024, timer=5;
  int s, done, stim;
  int in, out;
  int cooked_out=0;
  float lcomp,rcomp,dtim;
  struct tms Tbuf;

  timeout.tv_sec = 0;
  timeout.tv_usec = 0; 

  /* set_nonblock(0); */
  priority = 3;
  /*  first = client_options(argc, argv,"",NULL);*/

  s = connect_server(term_server);

  STAT ( 1, -5);

  scale = atoi(command_result) / 10 + 10;

  STAT ( 1, -3);
  sscanf ( command_result, "%d %d", &last_in, &last_out );
  stim=times(&Tbuf);
  STAT ( 1, -8);
  cooked_out = atoi(command_result);

  done = 0;
  while ( !done )
    { 
      /* Get the local compression stats. */
      STAT ( 1, -2 );
      sscanf ( command_result, "%d %d", &d1, &d2 );
      if (d1 != 0)
	lcomp = ((float) d1 - d2) / ((float) d1) * 100.0;
      else
	lcomp  = 0;

      /* Get the remote compression stats. */
      STAT ( 0, -2 );
      sscanf ( command_result, "%d %d", &d1, &d2 );
      if (d1!=0)
	rcomp=((float) d1-d2)/((float)d1) * 100.0;
      else rcomp = 0;

      /* Get the number of local clients */
      /* waiting to send. */
      STAT (1, -7);
      STAT (0, -7);
      STAT ( 1, -3);
      sscanf ( command_result, "%d %d", &d1, &d2 );
      
      for (i=1;i<33;i++) {
	ihist[i-1]=ihist[i];
	ohist[i-1]=ohist[i];
      }
      dtim=((float)(times(&Tbuf)-stim) * HZ ) / 10000.0;
      stim=times(&Tbuf);
      
      ihist[32]=(d1-last_in)/dtim;
      ohist[32]=(d2-last_out)/dtim;
      
      in = (int)((d1-last_in)/dtim);
      out = (int)((d2-last_out)/dtim);

      XcBGUpdateValue(IncomingCPS, &in);
      XcBGUpdateValue(OutgoingCPS, &out);
      
      last_in=d1;last_out=d2;
      
      timeout.tv_sec = timer;
      timeout.tv_usec = 0; 
      done = 1;
      usleep(500000);
    }
  
  close(s);

  return False;
}

/*********************************************************************
 * Function main.
 *********************************************************************/
main (argc, argv)
     int argc;
     char *argv[];
{
  /* Local variables */
  int i = 0;
  Arg args[10];
  Display *display;
  int scr_num;

  XtWorkProcId work_id;
  XtAppContext app;

  /* Initialize the toolkit and TopLevel window. */
  TopLevel = XtVaAppInitialize(&app, "Xtmon", NULL, 0, &argc, argv, NULL,
			     NULL);
  
  display = XtDisplay(TopLevel);
  scr_num = DefaultScreen(display);
  
  /*
   * Create the main form widgets to manage all of the other application 
   * widgets.
   */
  MainBox = XtCreateManagedWidget("mainbox", formWidgetClass,
				  TopLevel, NULL, 0);
  Panel1 = XtCreateManagedWidget("panel1", formWidgetClass,
				 MainBox, NULL, 0);

  ButtonBox = XtCreateManagedWidget("buttonbox", formWidgetClass,
				    MainBox, NULL,0);
  
  i = 0;
  XtSetArg(args[i], XtNfromHoriz, Panel1);  i++;
  XtSetValues(ButtonBox, args, i);
  

/*
 * Create two Buttons: the first is used to exit the application, and
 * the second resets the Lcd1 widget's counter value to 0.
 */
  FooButton1 = XtCreateManagedWidget("Button1", xcSimpleButtonWidgetClass,
					Panel1, NULL, 0);
  i = 0;
  XtSetArg(args[i], XtNfromHoriz, FooButton1);  i++;
  /*   XtSetValues(FooButton1, args, i);*/

  
  /*
   * Create two BarGraphs: the first one displays Slider1's value if
   * Toggle2 is set to On, and the second one is used to display Lcd1's
   * value.
   */
  IncomingCPS = XtCreateManagedWidget("IncomingCPS", xcBarGraphWidgetClass,
				      ButtonBox, NULL, 0);
  OutgoingCPS = XtCreateManagedWidget("OutgoingCPS", xcBarGraphWidgetClass,
				      ButtonBox, NULL, 0);
  i = 0;
  XtSetArg(args[i], XtNfromHoriz, OutgoingCPS);  i++;
  XtSetValues(IncomingCPS, args, i);
  
  /* Now register the callback functions for these widgets. */
  XtAddCallback(FooButton1, XcNactivateCallback, Quit, NULL);

  work_id = XtAppAddWorkProc(app, (XtWorkProc)do_monitor, NULL);

  XtRealizeWidget(TopLevel);

  XtAppMainLoop(app);
  
}













