/*
	This file is part of PPPCOSTS, version 0.05
	Copyright (c) 1996,97 Tillmann Steinbrecher.
	May be distributed according to the terms of the GNU
	General Public License version 2. No warranty.

	Modified by Lee Maguire <lee@wetware.demon.co.uk>
	07-jun-97
         * national daytime rates reduced
         * discount schemes added

        British Telecom  :  PRICE PER MINUTE STRUCTURE
          http://www.shop-athome.bt.com/home/pricing/uk.htm

        for information on other uk phone tarrifs see: 
        http://www.magsys.co.uk/telecom/

       --------------------------------------------------------------
       Calls are subject to a minimum charge of 5p and include VAT.
                           local  regional  national 
       mon-fri 0800-1759   3.95p  7.91p     7.91p    peak 
       mon-fri 0000-0759   1.65p  3.95p     4.65p    off-peak morning
       mon-fri 1800-2359   1.65p  3.95p     4.65p    off-peak evening
       sat-sun 0000-2359   1.00p  3.29p     3.29p    weekend

         discount schemes             normal cost * n = actual cost
         -------------------------    -----------------------------
         option15 :            10%    0.9
         premier line :        15%    0.85
         friends & family :    10%    0.9
         option15 + f&f :      20%    0.8
         premier line + f&f :  25%    0.75
 
       codes: 0800 - free /  0835 0845 - local /  0990 - national
  
       For calls which run over one charge period, each part of the call 
       will be charged pro rata. Normal charges apply on all Bank
       Holidays,  except certain days during Christmas and New Year.
       ----------------------------------------------------------------

	Please modify this file for your phone company's prices
	and send it to tst@bigfoot.com. Thanks a lot! 
*/

#include "costs.h"

char DECIMALS='2';	/* eg 2 for 5.55 */
float INITIAL_COST=0.0;
char CURRENCY_AFTER_COST=0;
char CURRENCY[10]="";
float MIN_COST=0.05;	/* 5p minimum */
char PRICE_PER_MIN=1;

/* define the rate for your IAP's area code */ 
/* local : eg for Demon's LoCall ROMPs */
#define BT_LOCAL              

/* regional : up to  35miles (for IAPs without local coverage) */
/* #define BT_REGIONAL */ 
/* national : over 35miles (get a new IAP!!!) */
/* #define BT_NATIONAL  */
/* premium : some 089X IAPs exist, re-check pricing first */
/* #define BT_PREMIUM */

/* optional : the cost 1.00 minus a discount - eg for 10% = 0.90 */
/* #define DISCOUNT 0.9  */

/*--------------------------------------------------------------*/

#ifdef BT_LOCAL
#define BT_PEAK        0.0395
#define BT_OFF_PEAK    0.0165
#define BT_WEEKEND     0.01
#endif

#ifdef BT_REGIONAL
#define BT_PEAK        0.0823
#define BT_OFF_PEAK    0.0395
#define BT_WEEKEND     0.0329
#endif

#ifdef BT_NATIONAL
#define BT_PEAK        0.0879
#define BT_OFF_PEAK    0.0465
#define BT_WEEKEND     0.0329
#endif

#ifdef BT_PREMIUM
/* i think these prices are usually correct : check first */
#define BT_PEAK        0.50    
#define BT_OFF_PEAK    0.45
#define BT_WEEKEND     0.45
#endif

int getunitlength(time_t tt){
        struct tm* ct;
        /* Costs per minute for British Telecom - hardcoded. */
        ct=localtime(&tt);
        /*      printf(" It's %u o'clock.\n", ct->tm_hour); */
        if(*ctime(&tt)=='S'){     /* Smart way to check for weekends ;-) */
                                    COSTS_PER_UNIT=BT_WEEKEND;
        } else {       
                if(ct->tm_hour<8)   COSTS_PER_UNIT=BT_OFF_PEAK;
                if(ct->tm_hour>=8 
                && ct->tm_hour<18 ) COSTS_PER_UNIT=BT_PEAK;
                if(ct->tm_hour>=18) COSTS_PER_UNIT=BT_OFF_PEAK;
        }
#ifdef DISCOUNT
        COSTS_PER_UNIT=COSTS_PER_UNIT * DISCOUNT;
#endif 
        return (60);
 }

/* eof */
