/*
	This file is part of PPPCOSTS, version 0.05
	Copyright (c) 1996,97 Tillmann Steinbrecher.
	May be distributed according to the terms of the GNU
	General Public License version 2. No warranty.

	Modified by Mikael hultgren <child@algonet.se>
	06-jul-97
       
       *-----------------------------------------------------------------*
        Swedish Telia  :  PRICE PER MINUTE STRUCTURE
        Calls are subject to a minimum charge of 0.30 Kr .
       
 			   Nar     Regional   Fjarrsamtal Celluar
       mon-fri 0800-1759   0.20kr   0.60Kr      0.80Kr    4.32Kr  Peak 
       mon-fri 1800-0759   0.10Kr   0.30Kr      0.40Kr    2.88Kr  Off-peak 
       sat-sun 0000-2359   0.10Kr   0.30Kr      0.40Kr    2.88Kr  Weekend
       *-----------------------------------------------------------------*

 	
       *-----------------------------------------------------------------* 
 	Swedish Tele2 : PRICE PER MINUTE STRUCTURE
        Calls are subject to a minimum charge of 0.35 Kr .
       
 			   Nar    Regional  Fjarrsamtal Celluar
       mon-fri 0800-1759   0.20kr  0.60Kr     0.60Kr  	3.70Kr  Peak 
       mon-fri 1800-0759   0.10Kr  0.30Kr     0.30Kr    2.50Kr	Off-peak 
       sat-sun 0000-2359   0.10Kr  0.30Kr     0.30Kr    2.50Kr	Weekend
       *-----------------------------------------------------------------*
 	
 	Please modify this file for your phone company's prices
	and send it to tst@bigfoot.com. Thanks a lot! 
*/

#include "costs.h"

char DECIMALS= '2';         /* eg 2 for 5.55 */
float INITIAL_COST=0.0;
char CURRENCY_AFTER_COST=1; /* Makes the currency appear after the cost */
char CURRENCY[10]=" Kr";
char PRICE_PER_MIN=1;

/*--------------- Define the rate for youre isp --------------*/
/*---(NAR_SAMTAL,REGION_SAMTAL,FJARR_SAMTAL,CELLUAR_SAMTAL)---*/ 
#define NAR_SAMTAL

/*-------------- Define which Phone Company ------------------*/
/*---------------------(Telia,Tele2)--------------------------*/

#ifdef Telia
	float MIN_COST=0.30;    /* 0.30Kr minimum Charge */
#else
	float MIN_COST=0.35;    /* 0.35Kr minimum Charge */
#endif
/*--------------------------------------------------------------*/

#ifdef NAR_SAMTAL
#define PEAK        0.20
#define OFF_PEAK    0.10
#define WEEKEND     0.10
#endif

#ifdef REGION_SAMTAL
#define PEAK        0.60
#define OFF_PEAK    0.30
#define WEEKEND     0.30
#endif

#ifdef FJARR_SAMTAL
#ifdef Telia
#define PEAK        0.80
#define OFF_PEAK    0.40
#define WEEKEND     0.40
#else
#define PEAK 	    0.60
#define OFF_PEAK    0.30
#define WEEKEND     0.30
#endif
#endif

#ifdef CELLUAR_SAMTAL
#ifdef Telia
#define PEAK        4.32
#define OFF_PEAK    2.88
#define WEEKEND     2.88
#else
#define PEAK	    3.70
#define OFF_PEAK    2.50
#define WEEKEND	    2.50
#endif
#endif

int getunitlength(time_t tt){
        struct tm* ct;
        /* Costs per minute for Swedish Telia - hardcoded. */
        ct=localtime(&tt);
        /*      printf(" It's %u o'clock.\n", ct->tm_hour); */
        if(*ctime(&tt)=='S'){     /* Smart way to check for weekends ;-) */
                                    COSTS_PER_UNIT=WEEKEND;
        } else {       
                if(ct->tm_hour<8)   COSTS_PER_UNIT=OFF_PEAK;
                if(ct->tm_hour>=8 
                && ct->tm_hour<18 ) COSTS_PER_UNIT=PEAK;
                if(ct->tm_hour>=18) COSTS_PER_UNIT=OFF_PEAK;
        }
#ifdef DISCOUNT
        COSTS_PER_UNIT=COSTS_PER_UNIT * DISCOUNT;
#endif 
        return (60);
 }

/* eof */
