/* 
	This file is part of PPPCOSTS.
	Copyright (c) 1996,97 Tillmann Steinbrecher.
	May be distributed according to the terms of the GNU
	General Public License version 2. No warranty.

	Phone costs for the South African Telco, "Telkom".
        Latest Prices for internal calls as of 14/01/1997.

===========================================================================
                 +                METERING PERIOD (secs)               
  Distance (km)  +      StandardTime          +      CallMoreTime
                 +  (weekdays 07:00-19:00)    +   (Weekdays 19:00-07:00)
                 +                            +     (Saturday, Sunday)
--------------------------------------------------------------------------
    0-50         +           180              +             480
    50-100       +           37.6             +             75.2
    100-200      +           18.8             +             45.2
    >200         +           13.6             +             28.8   
===========================================================================
                    A call unit is 30.9 cents.

	Please modify this file for your phone company's prices
	and send it to tst@bigfoot.com. Thanks a lot! 
*/

#include "costs.h"

char DECIMALS= '2';
float INITIAL_COST=0;
char CURRENCY_AFTER_COST=0;
char CURRENCY[10]="R ";
float COSTS_PER_UNIT=0.309;               /*  including VAT */

#define CALL_DISTANCE_50       /*  or 100, 200, 200plus   (km) */

#ifdef CALL_DISTANCE_50

int getunitlength(time_t tt){
	int unitsecs;
	struct tm* ct;
	/* Phone unit lengths for South African Telecom - hardcoded. */
	ct=localtime(&tt);
	/*	printf(" It's %u o'clock.\n", ct->tm_hour); */
	if(*ctime(&tt)=='S'){     /* Smart way to check for weekends ;-) */
		
		unitsecs=480;

	} else {          /*  during Week */ 
	
		if(ct->tm_hour < 7)	 	 	unitsecs=480;
		if(ct->tm_hour>=7 &&  ct->tm_hour<19)   unitsecs=180;
		if(ct->tm_hour>= 19) 		        unitsecs=480;	
        }
	return unitsecs;
 }
#endif	

#ifdef CALL_DISTANCE_100
int getunitlength(time_t tt){
	int unitsecs;
	struct tm* ct;
	/* Phone unit lengths for South African Telecom - hardcoded. */
	ct=localtime(&tt);
	/*	printf(" It's %u o'clock.\n", ct->tm_hour); */
	if(*ctime(&tt)=='S'){  /* Smart way to check for weekends ;-) */
		
		unitsecs=75.2;

	} else {          /*  during Week  */
	
		if(ct->tm_hour < 7)	 	 	unitsecs=75.2;
		if(ct->tm_hour>=7 &&  ct->tm_hour<19)   unitsecs=37.6;
		if(ct->tm_hour>= 19) 		        unitsecs=75.2;	
        }
	return unitsecs;
 }

#endif

#ifdef CALL_DISTANCE_200
int getunitlength(time_t tt){
	int unitsecs;
	struct tm* ct;
	/* Phone unit lengths for South African Telecom - hardcoded. */
	ct=localtime(&tt);
	/*	printf(" It's %u o'clock.\n", ct->tm_hour); */
	if(*ctime(&tt)=='S'){  /* Smart way to check for weekends ;-) */
		
		unitsecs=45.2;

	} else {             /*  during week  */
	
		if(ct->tm_hour < 7)	 	 	unitsecs=45.2;
		if(ct->tm_hour>=7 &&  ct->tm_hour<19)   unitsecs=18.8;
		if(ct->tm_hour>= 19) 		        unitsecs=45.2;	
        }
	return unitsecs;
 }

#endif

#ifdef CALL_DISTANCE_200plus
int getunitlength(time_t tt){
	int unitsecs;
	struct tm* ct;
	/* Phone unit lengths for South African Telecom - hardcoded. */
	ct=localtime(&tt);
	/*	printf(" It's %u o'clock.\n", ct->tm_hour); */
	if(*ctime(&tt)=='S'){  /* Smart way to check for weekends ;-) */
		
		unitsecs=28.8;

	} else {            /* during week */
	
		if(ct->tm_hour < 7)	 	 	unitsecs=28.8;
		if(ct->tm_hour>=7 &&  ct->tm_hour<19)   unitsecs=13.6;
		if(ct->tm_hour>= 19) 		        unitsecs=28.8;	
        }
	return unitsecs;
 }

#endif
