/*
        This file is part of PPPCOSTS.
        Copyright (c) 1996,97 Tillmann Steinbrecher.
        May be distributed according to the terms of the GNU
        General Public License version 2. No warranty.

	Updated: 24/05/99 by Rui M. Silva
	<rms@ssi.aaum.pt>

        Phone costs for Portugal Telecom, May 1999.

        LOCAL+ prices:
        If you are connected to an University, PT does
	not consider your call as an Internet Call, and
	thus it won't allow you to profit from the NET+
	discounts. INSTEAD, they provide the LOCAL+ service,
	in wich you can specify up to 3 local numbers which
	will have a discount per call. Don't worry, this is
	NOT ILEGAL, they're just plain induhviduals...
	... fourtunately :)

        Modified by Pedro Abreu
        <paab@camoes.rnl.ist.utl.pt>

        Phone costs for Portugal Telecom, February 1999.

        NET+ prices:
        Always considered local call, with economic period
        starting at 18:00 and no call activation unit.
        I think all main ISP's have NET+ numbers now.

        Local prices:
        Seconds per unit is the same as NET+, but economic
        period starts at 21:00 and you pay one extra unit for
        every time a call is established.

        Regional/National prices:
        Please consider changing ISP or living closer to  
        civilization.

        Notes:
        10% "over 30 hours in economic period" discount and
        call activation unit are NOT taken into consideration
        in the costs file. But holydays are.

        Please modify this file for your phone company's prices
        and send it to tst@bigfoot.com. Thanks a lot!
*/

#include "costs.h"


char DECIMALS= '2';
float INITIAL_COST=9.2;
char CURRENCY_AFTER_COST=0;
char CURRENCY[10]="Esc ";

/* configuration ********************************************************/

#define PT_INCLUDE_TAX          /* #undef to exclude taxes */
#define PT_NETP_PERIOD          /* #undef if your number is not NET+ */
#define PT_LOCAL_CALL           /* #undef for regional calls */
#undef PT_LOCAL_PLUS		/* #define if you have a local+ number */

/* end of configuration *************************************************/

#ifdef PT_LOCAL_PLUS
 INITIAL_COST-=6.32;
#endif

#ifdef PT_INCLUDE_TAX
float COSTS_PER_UNIT=  10.764;   /* including 17% IVA */
#else
float COSTS_PER_UNIT=  9.2;    /* excluding 17% IVA */
#endif

#ifdef PT_LOCAL_CALL
 #define PT_ECONOMIC     400     /* 6 minutes and 40 seconds */
 #define PT_NORMAL       180     /* 3 minutes */
#else
 #ifdef PT_REGIONAL_CALL
  /* REGIONAL CALLS YOU SHOULD CHANGE YOUR NETWORK */
  #define PT_ECONOMIC     74.8      /* 74.8 seconds */
  #define PT_NORMAL       36.5      /* 36.5 seconds */
 #else
  /* NATIONAL CALLS YOU ARE BEING EITHER * CRAZY * OR SHOULD CHANGE
     YOUR NETWORK */
  #define PT_ECONOMIC     27.1      /* 74.8 seconds */
  #define PT_NORMAL       14.6      /* 36.5 seconds */
 #endif
#endif

int getunitlength(time_t tt) {

int unitsecs;
struct tm* ct;
ct=localtime(&tt);

/* weekends or holydays *************************************************/
if (*ctime(&tt)=='S'            /* Smart way to check for weekends ;-) */
    || ct->tm_yday == 0         /* 1st January */
    || ct->tm_yday == 114       /* 25th April */
    || ct->tm_yday == 120       /* 1st May */
    || ct->tm_yday == 160       /* 10th June */
    || ct->tm_yday == 226       /* 15th August */
    || ct->tm_yday == 277       /* 5th October */
    || ct->tm_yday == 304       /* 1st November */
    || ct->tm_yday == 334       /* 1st December */
    || ct->tm_yday == 341       /* 8th December */
    || ct->tm_yday == 358)      /* 25th December */
        unitsecs = PT_ECONOMIC;

/* weekdays that are not holydays ***************************************/
else {
#ifdef PT_NETP_PERIOD
        if (ct->tm_hour >= 9 && ct->tm_hour < 18) unitsecs = PT_NORMAL;
#else
        if (ct->tm_hour >= 9 && ct->tm_hour < 21) unitsecs = PT_NORMAL;
#endif
        else unitsecs = PT_ECONOMIC;
}


return unitsecs;
} /* getunitlenght */
