/*
   This file is part of PPPCOSTS, version 0.05
   Copyright (c) 1996,97 Tillmann Steinbrecher.
   May be distributed according to the terms of the GNU
   General Public License version 2. No warranty.

   Modified by Luc Janssen <ljanssen@pi.net>
   30-jun-97
    * new rates are used according to the `BelBasis' and 
      `BelPlus' choice of PTT Telecom in the Netherlands.

   Modified by Erwin Waterlander <waterlan@xs4all.nl>
   25-mar-1999
    * Tarif changes per 1-jul-1998
      (Name changed from PTT to KPN)

   Modified by Erwin Waterlander <waterlan@xs4all.nl>
   3-aug-1999
    * Tarif update

       --------------------------------------------------------------
       Prices are per minute. Payments are per second!
       ----------------------------------------------------------------
   
   tarifs d.d. Aug 2 1999 (incl. BTW)
   as specified at http://www.ptt-telecom.nl/
   
   start charge: 10ct
   
   prices per minute:
   
   Three types of charging: `BelBasis' and `BelPlus' and 'BelBudget'

                        BelBasis    BelPlus    BelBudget
binnen regio

   mon-fri 0800-1959      6.0ct      6.0ct     20.0ct   piek
   mon-fri 0000-0759      2.0ct      2.0ct     6.67ct   dal with discount *
   sat     0000-2359      2.0ct      2.0ct     6.67ct   dal with discount *
   sun     0000-2359      2.0ct      2.0ct     6.67ct   dal with discount
   Other days and time    3.0ct      2.5ct     10.0ct   dal

   (* The discount on Saturday and mon-fri 0000-0759 is temporarely
      from April 6 till Sep 1 1999.)

buiten regio

   mon-fri 0800-1959     12.5 ct    12.5 ct     60.0ct   piek
   sun     0000-2359      6.25ct     4.69ct     30.0ct   dal with 0% discount
   Other days and time    6.25ct     4.69ct     30.0ct   dal

       ----------------------------------------------------------------

   Please modify this file for your phone company's prices
   and send it to tst@bigfoot.com. Thanks a lot! 
*/

#include "costs.h"

char DECIMALS= '2';          /* eg 2 for 5.55 */
float INITIAL_COST = 0.10;  /* Necessary for the start charge of 10ct. */
char CURRENCY_AFTER_COST = 0;
char CURRENCY[10]="f ";       /* Dutch guilders */

/* Define what type of charging is in use for you: */
/* #define NL_BELBASIS */
/* #define NL_BELPLUS */
#define NL_BUDGET


/* define the rate for your IAP's area code */ 
#define NL_BINNEN_REGIO       
/* #define NL_BUITEN_REGIO */ 

/*-----------------------------------------------------------------------*/
/* The following prices are guilders per second and include VAT (BTW)    */

#ifdef NL_BELBASIS
#  ifdef NL_BINNEN_REGIO
#    define NL_DAL         0.0005
#    define NL_PEAK        0.001
#    define DISCOUNT       0.66667
#  endif

#  ifdef NL_BUITEN_REGIO
#    define NL_DAL         0.0010417
#    define NL_PEAK        0.0020833
#  endif
#endif

#ifdef NL_BELPLUS
#  ifdef NL_BINNEN_REGIO
#    define NL_DAL         0.0004167
#    define NL_PEAK        0.001
#    define DISCOUNT       0.80
#  endif

#  ifdef NL_BUITEN_REGIO
#    define NL_DAL         0.0007817
#    define NL_PEAK        0.0020833
#  endif
#endif

#ifdef NL_BUDGET
#  ifdef NL_BINNEN_REGIO
#    define NL_DAL         0.0016667
#    define NL_PEAK        0.0033333
#    define DISCOUNT       0.66667
#  endif

#  ifdef NL_BUITEN_REGIO
#    define NL_DAL         0.005
#    define NL_PEAK        0.01
#  endif
#endif

int getunitlength(time_t tt){
        struct tm* ct;

        ct=localtime(&tt);
        /*
        printf(" It's %u %u %u (yy mm dd).\n", ct->tm_year,ct->tm_mon,ct->tm_mday);
        printf(" It's weekday %u.\n", ct->tm_wday);
        printf(" It's %u o'clock %u minutes.\n", ct->tm_hour,ct->tm_min);
        */
        if(*ctime(&tt)=='S')  /* Smart way to check for weekends ;-) */
        {   
            COSTS_PER_UNIT=NL_DAL;
        } 
      else 
        {       
            if(ct->tm_hour>=8 && ct->tm_hour<20 ) 
               COSTS_PER_UNIT=NL_PEAK;
            else 
               COSTS_PER_UNIT=NL_DAL;
        }

#ifdef DISCOUNT
        if (   (ct->tm_wday==0)                          /* Sunday */
            || (    (ct->tm_wday == 6)                      /* Saturday */
                 && (ct->tm_mon < 8) && (ct->tm_year <= 99) /*  before Sep 1 1999 */
               )
            || (    (*ctime(&tt)!='S')                     /* mon-fri */
                 && (ct->tm_hour>=0 && ct->tm_hour<8)      /* 0000 - 0759 */
                 && (ct->tm_mon < 8)&& (ct->tm_year <= 99) /*  before Sep 1 1999 */
               )
            )
        COSTS_PER_UNIT=COSTS_PER_UNIT * DISCOUNT;
#endif 
        return (1);
 }

/* eof */
