/* 
	This file is part of PPPCOSTS.
	Copyright (c) 1996,97 Tillmann Steinbrecher.
	May be distributed according to the terms of the GNU
	General Public License version 2. No warranty.

	Modified by Ivano Croce
	<crc1@freenet.hut.fi>

	Costi per Telecom Italia.
	In vigore da luglio 1997 e validi fino a dicembre 1997.
	
	Phone costs for the Italian public phone company Telecom Italia.
	Valid from July 1997 and until December 1997.
*/

#include "costs.h"

char DECIMALS= '0';
float INITIAL_COST=0;
char CURRENCY_AFTER_COST=0;
char CURRENCY[10]="L.";
float COSTS_PER_UNIT=151.13;  /* Lire 127 + IVA=19% */
/* float COSTS_PER_UNIT=127;  /* Lire 127 senza IVA */ 

#define CURRENCY "L. "

#define DECIMALS "0"

/* Decommentare la fascia applicata  - Uncomment the applicable zone  */

/* Tariffa urbana                    - Local area call                */
#define	TI_ZONE1 

/* Interurbana fino a 15 Km          - Long distance call up to 15 Km */
/* #define	TI_ZONE2                                              */                                           

/* Interurbana tra 15 e 30 Km        - Long distance call 15 to 30 Km */
/* #define	TI_ZONE3                                              */

/* Interurbana tra 30 e 60 Km        - Long distance call 30 to 60 Km */
/* #define	TI_ZONE4                                              */

/* Interurbana oltre i 60 Km         - Long distance call over 60 Km  */
/* #define	TI_ZONE5                                              */


/* Durata scatto TUT                 - Unit length: local area        */
#ifdef TI_ZONE1
#define	TI_BLUE         400
#define	TI_CYAN         400
#define	TI_YELLOW       220
#define	TI_ORANGE       220
#endif

/* Durata scatto int. fino a 15 Km   - Unit length: up to 15 Km       */
#ifdef TI_ZONE2
#define	TI_BLUE         150   
#define	TI_CYAN         130   
#define	TI_YELLOW        75   
#define	TI_ORANGE        65
#endif

/* Durata scatto int. tra 15 e 30 Km - Unit length: 15 to 30 Km       */
#ifdef TI_ZONE3
#define	TI_BLUE          80   
#define	TI_CYAN          70   
#define	TI_YELLOW        40   
#define	TI_ORANGE        39
#endif

/* Durata scatto int. tra 30 e 60 Km - Unit length: 30 to 60 Km       */
#ifdef TI_ZONE4
#define	TI_BLUE          50   
#define	TI_CYAN          45   
#define	TI_YELLOW        22   /* Effettivamente 22.5 - Actually 22.5 */
#define	TI_ORANGE        22   /* Effettivamente 22.5 - Actually 22.5 */
#endif

/* Durata scatto int. oltre i 60 Km  - Unit length: over 60 Km        */
#ifdef TI_ZONE5
#define	TI_BLUE          45   
#define	TI_CYAN          37   
#define	TI_YELLOW        20   
#define	TI_ORANGE        20
#endif

int easter_monday(int day, int month, int year)
{
   int a, m, easterday, eastermonth = 3;

   /* Trova quand' Pasqua - Finds Easter Day (O'Beirne's algorithm) */
   a = year % 19;
   m = (11 * a + 4 - ((7 * a + 1) / 19)) % 29;
   easterday = 25 - m - ((year + year / 4 + 31 - m) % 7);

   if (easterday > 0)
      eastermonth = 4;
   else
      easterday += 31;
      
   /* Rende il controllo successivo utilizzabile in tutti i casi */   
   if (easterday == 31)
   {
      easterday = 0;
      eastermonth = 4;
   }
    
   /* 1 per il luned di Pasqua, senn 0 - 1 if it's Easter Monday, 0 otherwise */   
   return (easterday + 1 == day && eastermonth - 1 == month);
}

int getunitlength(time_t tt)
{
   int unitsecs, dow;
   float hour;
   struct tm* ct;
  
   /* Giorno settimana ed ora locali - Local day of week and time */
   ct=localtime(&tt);
   dow = ct->tm_wday;
   hour = ct->tm_hour + ct->tm_min/60.;

   /* Festivit - Public holidays */
   if (    ct->tm_yday ==  0                       /* Capodanno  - New Year   */
       || (ct->tm_mday ==  5)                      /* Epifania   - Epiphany   */
       || (ct->tm_mday == 25 && ct->tm_mon ==  3)  /* Liberazione             */
       || (ct->tm_mday ==  1 && ct->tm_mon ==  4)  /* F. lavoro  - Labour Day */
       || (ct->tm_mday == 15 && ct->tm_mon ==  7)  /* Ferragosto - Assumption */
       || (ct->tm_mday ==  1 && ct->tm_mon == 10)  /* Ognissanti - All Saints'Day */
       || (ct->tm_mday ==  8 && ct->tm_mon == 11)  /* Immacolata              */
       || (ct->tm_mday == 25 && ct->tm_mon == 11)  /* Natale     - Christmas  */
       || (ct->tm_mday == 26 && ct->tm_mon == 11)) /* S. Stefano              */
          dow = 0; /* Equiparate a domeniche - Treated like Sunday */

   /* Controllo per vedere se  il luned di Pasqua */
   /* Check to know if it's Easter Monday */
   if (     dow == 1 
       && ((ct->tm_mday > 22 && ct->tm_mon == 2)
       ||  (ct->tm_mday < 27 && ct->tm_mon == 3)))
          if (easter_monday(ct->tm_mday, ct->tm_mon, ct->tm_year))
             dow = 0; /* Equiparato a domenica - Treated like Sunday */

   /* Applicazione fasce - Selection of the correct unit length */
   if (dow == 0)
       /* Domenica - Sunday */
       if (hour <   8 || hour >= 22)
                                            unitsecs = TI_BLUE;
       else
                                            unitsecs = TI_CYAN;
   else
       if (dow == 6)
       /* Sabato - Saturday */
       {
          if (hour <   8   || hour >= 22)   unitsecs = TI_BLUE;  
          if (hour >=  8   && hour <  13)   unitsecs = TI_YELLOW;
          if (hour >= 13   && hour <  22)   unitsecs = TI_CYAN;
       }
       else
       /* Altri giorni - Other days */
       {
          if (hour <   8   || hour >= 22)   unitsecs = TI_BLUE;  
          if (hour >=  8   && hour <   8.5) unitsecs = TI_YELLOW;
          if (hour >=  8.5 && hour <  13)   unitsecs = TI_ORANGE;
          if (hour >= 13   && hour <  18.5) unitsecs = TI_YELLOW;
          if (hour >= 18.5 && hour <  22)   unitsecs = TI_CYAN;
       }
	
   return unitsecs;
}

