/* 
	This file is part of PPPCOSTS.
	Copyright (c) 1996,97 Tillmann Steinbrecher.
	May be distributed according to the terms of the GNU
	General Public License version 2. No warranty.

	Pricing data provided by Toni Bilic
	    <tbilic@efos.hr>
	Modified by Dimitrios P. Bouras
	<dbouras@hol.gr>

	Phone costs for the Hrvatska posta i telekomunikacije eng.
	(the Croatian Mail and Telecommunications)
*/

#include "costs.h"

char DECIMALS= '2';
float INITIAL_COST=0;
char CURRENCY_AFTER_COST=1;
char CURRENCY[10]=" Kn";
float COSTS_PER_UNIT=0.186;

/* Pick one of two available scenarios */
#define HPT_REGISTERED
/* #define HPT_UNREGISTERED */

#ifdef HPT_REGISTERED
#define HPT_PEAK     60
#define HPT_OFF_PEAK 120
#endif

#ifdef HPT_UNREGISTERED
#define HPT_PEAK     30
#define HPT_OFF_PEAK 30
#endif

int getunitlength(time_t tt)
{
	int unitsecs;
	struct tm* ct;

	ct=localtime(&tt);
	if(ct->tm_hour < 7 || ct->tm_hour >= 22)
		unitsecs = HPT_OFF_PEAK;
	else
		unitsecs = HPT_PEAK;
	return unitsecs;
}

