/* 
	This file is part of PPPCOSTS.
	Copyright (c) 1996,97 Tillmann Steinbrecher.
	May be distributed according to the terms of the GNU
	General Public License version 2. No warranty.

	Pricing data provided by Toni Bilic
	<tbilic@efos.hr>
	Modified by Dimitrios P. Bouras
	<dbouras@hol.gr>

    Phone costs for the Croatian Academic and Research Network.
 
*/

#include "costs.h"

char DECIMALS= '0';
float INITIAL_COST=0;
char CURRENCY_AFTER_COST=1;
char CURRENCY[10]=" Kn";
float COSTS_PER_UNIT=0.186;

/* Pick one of two available zones */
#define CARNET_LOCAL
/* #define CARNET_NONLOCAL */

#ifdef CARNET_LOCAL
#define CARNET_PEAK     180
#define CARNET_OFF_PEAK 240
#define CARNET_NIGHT    360
#endif

#ifdef CARNET_NONLOCAL
#define CARNET_PEAK     36
#define CARNET_OFF_PEAK 48
#define CARNET_NIGHT    72
#endif

int getunitlength(time_t tt)
{
	int unitsecs;
	struct tm* ct;

	ct=localtime(&tt);
	if(ct->tm_hour < 7 || ct->tm_hour >= 22)
		unitsecs = CARNET_NIGHT;
	else {
		if(ct->tm_hour < 16)
			unitsecs = CARNET_PEAK;
		else
			unitsecs = CARNET_OFF_PEAK;
	}
	return unitsecs;
}

