/*
	This file is part of PPPCOSTS.
	Copyright (c) 1996,97 Tillmann Steinbrecher.
	May be distributed according to the terms of the GNU
	General Public License version 2. No warranty.

        Modified by Didier Chalm
        <Didier.Chalm@infini.fr>

	Modified by David Segonds
	<David.Segonds@ensg.u-nancy.fr>

	This is the cost file for the french phone company
	France Telecom after 1st October 1997.

	This is the most sophisticated cost file. Use this file
	as a basis for your own cost file if you want to consider
	holidays and/or different zones, e.g. for long distance
	calls.

	Please modify this file for your phone company's prices
	and send it to tst@bigfoot.com. Thanks a lot!=20
*/

#include "costs.h"

char DECIMALS= '2';
float INITIAL_COST=0.0;
char CURRENCY_AFTER_COST=1;
char CURRENCY[10]=" FF";
float MIN_COST=0.74;
char PRICE_PER_MIN=1;

/* UNE SEULE ZONE DOIT ETRE D=C9FINIE ! */

/* Zone locale  */
#define	FT_LOCAL

/* jusqu'a 25 km */
/* #define	FT_JUSQU_A_25_KM */

/* entre 25 et 30 km */
/* #define	FT_ENTRE_25_ET_30_KM */

/* entre 30 et 50 km */
/* #define	FT_ENTRE_30_ET_50_KM */

/* national */
/* #define	FT_NATIONAL */

#define PREMIERE_TAXE   0.74

#ifdef FT_LOCAL
#define	FT_PLEIN_TARIF  0.280
#define	FT_TARIF_REDUIT 0.140
#define CREDIT_TEMPS    180
#endif

#ifdef FT_JUSQU_A_25_KM
#define	FT_PLEIN_TARIF  0.400
#define	FT_TARIF_REDUIT 0.200
#define CREDIT_TEMPS    111
#endif

#ifdef FT_ENTRE_25_ET_30_KM
#define	FT_PLEIN_TARIF  0.600
#define	FT_TARIF_REDUIT 0.300
#define CREDIT_TEMPS    74
#endif

#ifdef FT_ENTRE_30_ET_50_KM
#define	FT_PLEIN_TARIF  0.950
#define	FT_TARIF_REDUIT 0.475
#define CREDIT_TEMPS    47
#endif

#ifdef FT_NATIONAL
#define	FT_PLEIN_TARIF  1.140
#define	FT_TARIF_REDUIT 0.570
#define CREDIT_TEMPS    39
#endif

int getunitlength(time_t tt){
    long online_secs=0;
    int d;
    struct tm* ct;
    float h;

    /* Phone unit lengths for France Telecom - hardcoded. */
    ct = localtime(&tt);
    h = ct->tm_hour + ct->tm_min/60.;
    d = ct->tm_wday;
    
    /* printf(" Il est %u:%u\n", ct->tm_hour, ct->tm_min); */
    /* Jours feries : d = 0 (= Dim) */
    /* Valeurs pour 1997 */

    if (   ct->tm_yday == 0     /* 1er janvier, Nouvel An */
        || ct->tm_yday == 89    /* 31 mars, Lundi de Paques */
        || ct->tm_yday == 120   /* 1er mai, Fete du Travail */
        || ct->tm_yday == 127   /* 8 mai, Ascension */
        || ct->tm_yday == 138   /* 19 mai, Lundi de Pentecote */
        || ct->tm_yday == 194   /* 14 juillet, Fete Nationale */
        || ct->tm_yday == 226   /* 15 aout, Assomption */
        || ct->tm_yday == 304   /* 1er novembre, Toussaint */
        || ct->tm_yday == 314   /* 11 novembre, Armistice 1918 */
        || ct->tm_yday == 358)  /* 25 decembre, Noel */
        d = 0;

    if (d == 0){ /* Dim ou jour ferie */
        COSTS_PER_UNIT = FT_TARIF_REDUIT;
    } else  if (d == 6){ /* Sam */
        if (h < 8)
            COSTS_PER_UNIT = FT_TARIF_REDUIT;
        if (h >= 8 &&  h < 12)
            COSTS_PER_UNIT = FT_PLEIN_TARIF;
        if (h >= 12)
            COSTS_PER_UNIT = FT_TARIF_REDUIT;
    } else { /* Lun, Mar, Mer, Jeu, Ven */
        if (h < 8)
            COSTS_PER_UNIT = FT_TARIF_REDUIT;
        if (h >= 8 &&  h < 19)
            COSTS_PER_UNIT = FT_PLEIN_TARIF;
        if (h >= 19)
            COSTS_PER_UNIT = FT_TARIF_REDUIT;
    }
    return(60);
}
