/*
        This file is part of PPPCOSTS.
        Copyright (c) 1996,97 Tillmann Steinbrecher.
        May be distributed according to the terms of the GNU
        General Public License version 2. No warranty.

        Modified by Juan Cirer
        <jcirer@arrakis.es>

        This is the cost file for the spanish phone company
        Telefonica de Espaa.

        Please modify this file for your phone company's prices
        and send it to tst@bigfoot.com. Thanks a lot! 

Note from Juan:

Following you instructions in the Readme file (I don't know C :( ), I
modified the ft-costs.c file.

Note from Tillmann:

See, it *is* possible to create a rather complex costfile
without knowing C :-)

Some modifications by Ragnar Hojland Espinosa <ragnar@lightside.ddns.org>
to implement the MIN_UNITS_PER_CALL. 

Las tarifas corresponden al tarifazo de agosto de 1998.  No se contemplan
bonos, primonets ni gaitas (lease planes "claros") porque es dificil saber
si T va a seguir el BOE o, como siempre, doblarlo a su antojo  --Ragnar

Todas las tarifas y costes vienen con un 16% IVA incluido.
*/

#include "costs.h"

char DECIMALS= '2';
float INITIAL_COST=0.0;
char CURRENCY_AFTER_COST=1;
char CURRENCY[10]=" Ptas";
float COSTS_PER_UNIT=0.0;
char PRICE_PER_MIN=1;

/* Tarifa Urbana */

#define T_NORMAL	5.2432
#define T_REDUCIDA	1.9024

int getunitlength (time_t tt)
{
        int d;
        struct tm* ct;
        float h;

        ct = localtime(&tt);
        h = ct->tm_hour + ct->tm_min/60.;
        d = ct->tm_wday;

        /* 1999: Reyes, segun en BOE, es fiesta nacional.  Segun Timofonica, no. */
        if (ct->tm_yday == 0         /* 1 Enero,  Cap d'Any */
                || ct->tm_yday == 120   /* 1 Mayo, Fiesta del Trabajo */
                || ct->tm_yday == 205   /* 25 Julio, Sant Jaume */
                || ct->tm_yday == 226   /* 15 Agosto, Mare de Deu d'Agost */
                || ct->tm_yday == 284    /* 12 Octubre, Virgen del Pilar */
                || ct->tm_yday == 304   /* 1 Noviembre, Tots Sants */
                || ct->tm_yday == 339   /* 6 Diciembre, La Constitucion */
                || ct->tm_yday == 284    /* 8 Diciembre, La Inmaculada */
                || ct->tm_yday == 358)  /* 25 Diciembre, Nadal */
                        d = 0;

        if (d == 0) {  /* Domingo o festivo */
               COSTS_PER_UNIT = T_REDUCIDA;
        } else {       /* Resto de la semana */
	   	if (h >= 8.0 && h < (d == 6 ? 14.0 : 22.0)) {
			COSTS_PER_UNIT = T_NORMAL;
		} else {
			COSTS_PER_UNIT = T_REDUCIDA;
		}
        }

	return 60;
}
