/*
	This file is part of PPPCOSTS, version.
	Copyright (c) 1996,97 Tillmann Steinbrecher.
	May be distributed according to the terms of the GNU
	General Public License version 2. No warranty.

	Modified by Thorsten Lyng Johansen <tljo93@kom.auc.dk>
	20-May-97
        
        TeleDanmarK  :  PRICE PER MINUTE STRUCTURE

        Based on http://www.teledanmark.dk/p_guide/takster/samtpris.htm
        ---------------------------------------------------------------------
        Calls are subject to a minimum charge of 0.125kr including VAT.
                            local    regional   national 
        mon-sat 0800-1929   0.32kr    0.47kr      0.70kr      peak 
        mon-sat 1930-0759   0.16kr    0.235kr     0.35kr      off-peak
        sun     0000-2359   0.16kr    0.235kr     0.35kr      sunday
        
        Be aware that local charge is more expensive in cities like
        Copenhagen (0,375/0,188) and  rhus, Odense and Aalborg (0,336/0,1675)
        ----------------------------------------------------------------------

	Please modify this file for your phone company's prices
	and send it to tst@bigfoot.com. Thanks a lot! 
*/

#include "costs.h"

char DECIMALS= '2';		/* eg 5.55 */
char CURRENCY_AFTER_COST=1;
char CURRENCY[10]=" kr";	/* or (DKR) */
float INITIAL_COST=0.0;
float MIN_COST=0.125;		/* 0.125kr minimum */
char PRICE_PER_MIN=1;
/* define the rate for your ISP's area code */ 

/* local : eg commune and neighbour communes */
/* #define TDK_LOCAL */              

/* regional : under 75km (for ISPs without local coverage) */
#define TDK_REGIONAL 

/* national : over 75km (get a new ISP!!!) */
/* #define TDK_NATIONAL  */

#ifdef TDK_LOCAL
#define TDK_PEAK        0.32
#define TDK_OFF_PEAK    0.16
#define TDK_SUNDAY      0.16
#endif

#ifdef TDK_REGIONAL
#define TDK_PEAK        0.47
#define TDK_OFF_PEAK    0.235
#define TDK_SUNDAY      0.235
#endif

#ifdef TDK_NATIONAL
#define TDK_PEAK        0.70
#define TDK_OFF_PEAK    0.35
#define TDK_SUNDAY      0.35
#endif

float COSTS_PER_UNIT;

int getunitlength(time_t tt){
  struct tm* ct;
  /* Costs per minute for Tele DanmarK - hardcoded. */
  ct=localtime(&tt);
  if(ct->tm_wday==0){ /* Check for sundays */   COSTS_PER_UNIT=TDK_SUNDAY;
  } 
  else {        
    if(ct->tm_hour<8)                           COSTS_PER_UNIT=TDK_OFF_PEAK;
    if((ct->tm_hour>=8) && (ct->tm_hour<19))    COSTS_PER_UNIT=TDK_PEAK;
    if((ct->tm_hour==19) && (ct->tm_min<30))    COSTS_PER_UNIT=TDK_PEAK;
    if((ct->tm_hour==19) && (ct->tm_min>=30))   COSTS_PER_UNIT=TDK_OFF_PEAK;
    if(ct->tm_hour>=20)                         COSTS_PER_UNIT=TDK_OFF_PEAK;
  }
  return (60);
}

//eof


