/*
        This file is part of PPPCOSTS.
	Copyright (c) 1996,97 Tillmann Steinbrecher.
        May be distributed according to the terms of the GNU
        General Public License version 2. No warranty.
  
	Modified by Klaus Herrmann
	<kherrman@aix550.informatik.uni-leipzig.de>

	This is the cost file for the German Telekom.
        (price list from 01/07/96)

        Currently this is the best & most sophisticated costfile.
	It has a "perpetual calender" and not hardcoded holidays.
	Note: this code needs the math library. If you create a
	costfile based on this one, make sure that you compile
	with "gcc -lm pppcosts.c"	

	Please modify this file for your phone company's prices
	and send it to tst@bigfoot.com. Thanks a lot! 
*/

#include "costs.h"

#include <math.h>

char DECIMALS= '2';
float INITIAL_COST=0;
char CURRENCY_AFTER_COST=0;
char CURRENCY[10]="DM";
float COSTS_PER_UNIT=0.12;        /* 0.1043 + 15% VAT */

/* Please uncomment the applicable zone! */

/* Zone City      (to 20 km)     */
#define	DT_ZONE1

/* Zone Region50  (20 to 50 km   */
/* #define	DT_ZONE2         */

/* Zone Region200 (50 to 200 km) */
/* #define	DT_ZONE3         */

/* Zone Fern (over 200 km)       */
/* #define	DT_ZONE4         */

#ifdef DT_ZONE1
/* normally, there are 5 daytime-dependent unit lengths */
#define	DT_VORMITTAG    	90
#define	DT_NACHMITTAG	        90
#define	DT_FREIZEIT	        150 
#define	DT_MONDSCHEIN         	240
#define DT_NACHT        	240
/* saturday and sunday  */
#define DT_FREIZEIT_WEEKEND	150
#define DT_MONDSCHEIN_WEEKEND	240
/* bank holidays */	
#define DT_FREIZEIT_HOLIDAY	150
#define DT_MONDSCHEIN_HOLIDAY	240
/* working days between x-mas and new year */
#define DT_VORMITTAG_SPECIAL	90	
#define DT_NACHMITTAG_SPECIAL	90
#define DT_FREIZEIT_SPECIAL	150
#define DT_MONDSCHEIN_SPECIAL	240
#define DT_NACHT_SPECIAL	240
#endif

#ifdef DT_ZONE2
/* normally, there are 5 daytime-dependent unit lengths */
#define DT_VORMITTAG            26
#define DT_NACHMITTAG           30
#define DT_FREIZEIT             45
#define DT_MONDSCHEIN           60
#define DT_NACHT                120
/* saturday and sunday  */
#define DT_FREIZEIT_WEEKEND     45
#define DT_MONDSCHEIN_WEEKEND   60
/* bank holidays */
#define DT_FREIZEIT_HOLIDAY     45
#define DT_MONDSCHEIN_HOLIDAY   60
/* working days between x-mas and new year */
#define DT_VORMITTAG_SPECIAL    36
#define DT_NACHMITTAG_SPECIAL   36
#define DT_FREIZEIT_SPECIAL     45
#define DT_MONDSCHEIN_SPECIAL   60
#define DT_NACHT_SPECIAL        120
#endif

#ifdef DT_ZONE3
/* normally, there are 5 daytime-dependent unit lengths */
#define DT_VORMITTAG            13
#define DT_NACHMITTAG           14
#define DT_FREIZEIT             22	/* exact 22.5 */
#define DT_MONDSCHEIN           36
#define DT_NACHT                120
/* saturday and sunday  */
#define DT_FREIZEIT_WEEKEND     22	/* exact 22.5 */
#define DT_MONDSCHEIN_WEEKEND   36
/* bank holidays */
#define DT_FREIZEIT_HOLIDAY     36
#define DT_MONDSCHEIN_HOLIDAY   36
/* working days between x-mas and new year */
#define DT_VORMITTAG_SPECIAL    36
#define DT_NACHMITTAG_SPECIAL   36
#define DT_FREIZEIT_SPECIAL     36
#define DT_MONDSCHEIN_SPECIAL   36
#define DT_NACHT_SPECIAL        120
#endif

#ifdef DT_ZONE4
/* normally, there are 5 daytime-dependent unit lengths */
#define DT_VORMITTAG            12
#define DT_NACHMITTAG           13	/* exact 13.5 */
#define DT_FREIZEIT             21	/* exact 21.5*/
#define DT_MONDSCHEIN           30
#define DT_NACHT                120
/* saturday and sunday   */
#define DT_FREIZEIT_WEEKEND     21	/* exact 21.5 */
#define DT_MONDSCHEIN_WEEKEND   30
/* bank holidays */
#define DT_FREIZEIT_HOLIDAY     36
#define DT_MONDSCHEIN_HOLIDAY   36
/* working days between x-mas and new year */
#define DT_VORMITTAG_SPECIAL    36
#define DT_NACHMITTAG_SPECIAL   36
#define DT_FREIZEIT_SPECIAL     36
#define DT_MONDSCHEIN_SPECIAL   36
#define DT_NACHT_SPECIAL        120
#endif

/* calculates the easter sunday in day_of_year style */
int get_easter(struct tm *ct){
	signed int a,b,m,q,w,p,n,tt,mm; /* not optimized, I took the original names */
	struct tm *ptm;
	struct tm htm;
	time_t htt;
	
	/* calculating easter is really funny */	
	/* this is O'Beirne's algorithm, only valid 1900-2099 */
	n = ct->tm_year;
	a = n % 19;
	b = floor((7*a+1)/19);
	m = (11*a+4-b) % 29;
	q = floor(n/4);
	w = (n+q+31-m) % 7;
	p = 25-m-w;
	if (p>0)
	{tt=p;
	 mm=4;}
 	else
 	{tt=p+31;
 	 mm=3;}

	/* changing d.m.y to day_of_year */
	htm.tm_year=ct->tm_year;
	htm.tm_mon=mm-1;
	htm.tm_mday=tt;
	htm.tm_hour=12;   /* fill with some possible values */
	htm.tm_min=0;
	htm.tm_sec=0;
	htt=mktime(&htm);
	ptm=localtime(&htt);
	
	return(ptm->tm_yday); }
 	         
/* returns the unit length currently valid */
int getunitlength(time_t tt){
	int unitsecs, d, easter_sun;
	struct tm* ct;
	float h;

	/* Phone unit lengths for German Telecom - hardcoded. */
	easter_sun = get_easter(localtime(&tt));
	ct = localtime(&tt);     /* localtime works a little bit curious */
	h = ct->tm_hour + ct->tm_min/60.;
	d = ct->tm_wday;

        if (       ct->tm_yday == 0                         /* 1.1., New Year */
                || ct->tm_yday == easter_sun-2              /* Karfreitag */
                || ct->tm_yday == easter_sun                /* Easter sunday */
                || ct->tm_yday == easter_sun+1              /* Easter monday */
                || ct->tm_yday == easter_sun+39             /* Christi Himmelfahrt */
                || ct->tm_yday == easter_sun+49             /* Pfingstsonntag */
                || ct->tm_yday == easter_sun+50             /* Pfingstmontag */
                || (ct->tm_mday == 1 && ct->tm_mon == 4)    /* may day (1.5.) */
                || (ct->tm_mday == 3 && ct->tm_mon == 9)    /* Deutsche Einheit (3.10.) */  
                || (ct->tm_mday == 24 && ct->tm_mon == 11)  /* x eve */ 
                || (ct->tm_mday == 25 && ct->tm_mon == 11)  /* x day */ 
                || (ct->tm_mday == 26 && ct->tm_mon == 11)  /* boxing day */ 
                || (ct->tm_mday == 31 && ct->tm_mon == 11)  /* Silvester */ 
                || (ct->tm_mon == 11 && ct->tm_mday>=27 && 
		    ct->tm_mday<=30 && (ct->tm_wday==0 ||ct->tm_wday==6)))
                                 /* saturday and sunday between 27 and 30 dec */
	  d = 9;
                        
	if (ct->tm_mon == 11 && ct->tm_mday>=27 && ct->tm_mday<=30 &&
	    ct->tm_wday>0 && ct->tm_wday<6)
            	                 /* working days between 27 and 30 dec */                 
	  d = 8;                                                                       
	                                          
                        
	if (d == 8){             /* working days between 27 and 30 dec */
	  if (h < 2)
	    unitsecs = DT_MONDSCHEIN_SPECIAL;
	  if (h >= 2 &&  h < 5)
	    unitsecs = DT_NACHT_SPECIAL;
	  if (h >= 5 &&  h < 9)   
	    unitsecs = DT_FREIZEIT_SPECIAL;
	  if (h >= 9 &&  h < 12)   
	    unitsecs = DT_VORMITTAG_SPECIAL;
	  if (h >= 12 &&  h < 18)   
	    unitsecs = DT_NACHMITTAG_SPECIAL;
	  if (h >= 18 &&  h < 21)   
	    unitsecs = DT_FREIZEIT_SPECIAL;
	  if (h >= 21 )   
	    unitsecs = DT_MONDSCHEIN_SPECIAL;
	} else {
	  
	  if (d == 9){           /* bank holidays */
	    if (h < 5)
	      unitsecs = DT_MONDSCHEIN_HOLIDAY;
	    if (h >= 5 &&  h < 21)
	      unitsecs = DT_FREIZEIT_HOLIDAY;
	    if (h >= 21 )
	      unitsecs = DT_MONDSCHEIN_HOLIDAY;
	  } else {

	    if (d == 0 || d == 6){  /* saturday and sunday */  
	      if (h < 5)
		unitsecs = DT_MONDSCHEIN_WEEKEND;
	      if (h >= 5 &&  h < 21)
		unitsecs = DT_FREIZEIT_WEEKEND;
	      if (h >= 21 )   
		unitsecs = DT_MONDSCHEIN_WEEKEND;
	    } else {	    
	                            /* normal working days */
	      if (h < 2)
		unitsecs = DT_MONDSCHEIN;
	      if (h >= 2 &&  h < 5)
		unitsecs = DT_NACHT;
	      if (h >= 5 &&  h < 9)   
		unitsecs = DT_FREIZEIT;
	      if (h >= 9 &&  h < 12)   
		unitsecs = DT_VORMITTAG;
	      if (h >= 12 &&  h < 18)   
		unitsecs = DT_NACHMITTAG;
	      if (h >= 18 &&  h < 21)   
		unitsecs = DT_FREIZEIT;
	      if (h >= 21 )   
		unitsecs = DT_MONDSCHEIN;
	    }}}
	
	return unitsecs;
}
