/* 
	This file is part of PPPCOSTS.
	Copyright (c) 1996,97 Tillmann Steinbrecher.
	May be distributed according to the terms of the GNU
	General Public License version 2. No warranty.

	Modified by Roland Egli
	<egli@swissonline.ch>

	Adapted to Sunrise by
	Tomas Pospisek <tpo@spin.ch>

	This is the cost file for the swiss phone company Surise.

	Costs per Unit don't really make sense because a unit is a second
	and so the cost is a fraction of a cent

	Date: 4.Feb.1999
*/

#include "costs.h"

char DECIMALS= '2';
float INITIAL_COST=0;
char CURRENCY_AFTER_COST=0;
char CURRENCY[10]="Fr.";
float COSTS_PER_UNIT=0.10;

/* you have to define one of these zones */
#define NAHBEREICH
/* #define FERNBEREICH */

#ifdef NAHBEREICH /* local call */
  #define NormalTarif  90
  #define NiederTarif 180
  #define NachtTarif  360
#endif

#ifdef FERNBEREICH /* national call */
  #define NormalTarif  30
  #define NiederTarif  60
  #define NachtTarif   120
#endif

int getunitlength(time_t tt){
	int unitsecs;
	struct tm* ct;
	/* Phone unit lengths for Swiss Telecom - hardcoded. */
	ct=localtime(&tt);
	/*	printf(" It's %u o'clock.\n", ct->tm_hour); */
	if(*ctime(&tt)=='S'){  /* Smart way to check for weekends ;-) */
                               /* TODO: should be the same for nat. holidays */
		if(ct->tm_hour < 8 || ct->tm_hour >= 23) {unitsecs=NachtTarif;}
		else {					  unitsecs=NiederTarif;}
	} else {
	

		if(ct->tm_hour < 8)	 	 	unitsecs=NachtTarif;
		if(ct->tm_hour>= 8 && ct->tm_hour<17)   unitsecs=NormalTarif;
		if(ct->tm_hour>=17 && ct->tm_hour<23)   unitsecs=NiederTarif;
		if(ct->tm_hour>=23) 		        unitsecs=NachtTarif;
        }
	return unitsecs;
 }




