/* 
	This file is part of PPPCOSTS.
	Copyright (c) 1996,97 Tillmann Steinbrecher.
	May be distributed according to the terms of the GNU
	General Public License version 2. No warranty.

	Modified by Roland Egli
	<egli@swissonline.ch>

	Modified by T.Pospisek <tpo@spin.ch> 7.April'99

	This is the cost file for the swiss phone company SwissCom
*/

#include "costs.h"

char DECIMALS= '2';
float INITIAL_COST=0.10;
char CURRENCY_AFTER_COST=0;
char CURRENCY[10]="Fr.";
float COSTS_PER_UNIT=0.10;

/* you have to define one of these zones */
#define NAHBEREICH
/* #define FERNBEREICH */

#ifdef NAHBEREICH
  #define NormalTarif  90
  #define NiederTarif 180
  #define NachtTarif  360
#endif

#ifdef FERNBEREICH
  #define NormalTarif  24
  #define NiederTarif  48
  #define NachtTarif   96
#endif


int getunitlength(time_t tt){
	int unitsecs;
	struct tm* ct;
	/* Phone unit lengths for Swiss Telecom - hardcoded. */
	ct=localtime(&tt);
	/*	printf(" It's %u o'clock.\n", ct->tm_hour); */

	if ((ct->tm_hour < 6) ||
	    (ct->tm_hour >= 22)) {
	    unitsecs = NachtTarif;
	} else {
	  if (*ctime(&tt)=='S') {  /* Smart way to check for weekends ;-)
		                    * Should include as well: 1. und 2. Januar,
				    * Karfreitag, Ostermontag, Auffahrt,
				    * Pfingstmontag, 1. August, 25. und 26.
				    * Dezember
				    */
	    unitsecs = NiederTarif;
	  } else {
	    if (ct->tm_hour >=  8 && ct->tm_hour < 17) {
	      unitsecs = NormalTarif;
	    } else {
	      unitsecs = NiederTarif;
	    }
	  }
	}

	return unitsecs;
 }




