/*
	This file is part of PPPCOSTS.
	Copyright (c) 1996,97 Tillmann Steinbrecher.
	May be distributed according to the terms of the GNU
	General Public License version 2. No warranty.

	Modified by Jean-Marc Wislez
	<jmwislez@charlie.luc.ac.be>

	This is the cost file for the belgian phone company
	Belgacom.

	Please modify this file for your phone company's prices
	and send it to tst@bigfoot.com. Thanks a lot! 
*/

#include "costs.h"

char DECIMALS= '2';
float INITIAL_COST=0;
char CURRENCY_AFTER_COST=1;
char CURRENCY[10]=" BEF";
float COSTS_PER_UNIT=6.05; /* 5.00 BEF, VAT = 21 % */

/* DEFINE ONLY ONE ZONE ! */

/* Zonal */
#define	BE_ZONAL

/* Interzonal A */
/* #define	BE_INTZONA */

/* Interzonal B */
/* #define	BE_INTZONB */

#ifdef BE_ZONAL
#define	BE_RED		240
#define	BE_YELLOW	360
#define	BE_BLACK	720
#endif

#ifdef BE_INTZONA
#define	BE_RED		150
#define	BE_YELLOW	180
#define	BE_BLACK	360
#endif

#ifdef BE_INTZONB
#define	BE_RED		40
#define	BE_YELLOW	50
#define	BE_BLACK	100
#endif

int getunitlength(time_t tt){
	int unitsecs, d;
	struct tm* ct;
	float h;

	/* Phone unit lengths for Belgacom - hardcoded. */
	ct = localtime(&tt);
	h = ct->tm_hour + ct->tm_min/60.;
	d = ct->tm_wday;
	/* printf(" It is now %u:%u\n", ct->tm_hour, ct->tm_min); */
	/* Public holidays */
	/* Values for 1997 */
	
	

        if (  ct->tm_wday == 6          /* Saturday */
                || ct->tm_yday == 0     /* January 1 */
                || ct->tm_yday == 89    /* March 31 */
                || ct->tm_yday == 120   /* May 1 */
                || ct->tm_yday == 127   /* May 8 */
                || ct->tm_yday == 138   /* May 19 */
                || ct->tm_yday == 201   /* July 21 */
                || ct->tm_yday == 226   /* August 15 */
                || ct->tm_yday == 304   /* November 1 */
                || ct->tm_yday == 358)  /* December 25 */
                        d = 0;
                        
	if (d == 0){  /* saturday, sunday or public holiday */
		unitsecs = BE_BLACK;
	} else {
			if (h < 8.0)
				unitsecs = BE_BLACK;
			if (h >= 8.0 &&  h < 9.0)
				unitsecs = BE_YELLOW;
			if (h >= 9.0 &&  h < 12.0)
				unitsecs = BE_RED;
			if (h >= 12.0 &&  h < 13.5)
				unitsecs = BE_YELLOW;
			if (h >= 13.5 &&  h < 17.0)
				unitsecs = BE_RED;
			if (h >= 17.0 &&  h < 18.5)
				unitsecs = BE_YELLOW;
                        if (h >= 18.5)
				unitsecs = BE_BLACK;
		} 
	return unitsecs;
}
