/*
        This file is part of PPPCOSTS.
	Copyright (c) 1996,97 Tillmann Steinbrecher.
        May be distributed according to the terms of the GNU
        General Public License version 2. No warranty.
  
	Modified by Matthias Kabel
	<matthias.kabel@salzburg.co.at>

	This is the cost file for the Austrian Telekom.
        (price list from 01/01/99)

        Currently this is the best & most sophisticated costfile.
	It has a "perpetual calender" and not hardcoded holidays.
	Note: this code needs the math library. If you create a
	costfile based on this one, make sure that you compile
	with "gcc -lm pppcosts.c"	

	Please modify this file for your phone company's prices
	and send it to tst@bigfoot.com. Thanks a lot! 
*/

#include <math.h>
#include "costs.h"

char DECIMALS= '2';
float INITIAL_COST=0;
char CURRENCY_AFTER_COST=0;
char CURRENCY[10]="ATS";

/* Please uncomment the applicable zone! */

#define	AT_ONLINE_STANDARD

#define AT_TAG			120
#define AT_NACHT		360

#ifdef AT_ONLINE_MINIMUM
float COSTS_PER_UNIT=1.116;        
#endif

#ifdef AT_ONLINE_STANDARD
float COSTS_PER_UNIT=1.056;        
#endif

#ifdef AT_ONLINE_GESCHAEFT1
float COSTS_PER_UNIT=0.996;        
#endif

#ifdef AT_ONLINE_GESCHAEFT2
float COSTS_PER_UNIT=0.936;        
#endif

/* calculates the easter sunday in day_of_year style */
int get_easter(struct tm *ct){
	signed int a,b,m,q,w,p,n,tt,mm; /* not optimized, I took the original names */
	struct tm *ptm;
	struct tm htm;
	time_t htt;
	
	/* calculating easter is really funny */	
	/* this is O'Beirne's algorithm, only valid 1900-2099 */
	n = ct->tm_year;
	a = n % 19;
	b = floor((7*a+1)/19);
	m = (11*a+4-b) % 29;
	q = floor(n/4);
	w = (n+q+31-m) % 7;
	p = 25-m-w;
	if (p>0)
	{tt=p;
	 mm=4;}
 	else
 	{tt=p+31;
 	 mm=3;}

	/* changing d.m.y to day_of_year */
	htm.tm_year=ct->tm_year;
	htm.tm_mon=mm-1;
	htm.tm_mday=tt;
	htm.tm_hour=12;   /* fill with some possible values */
	htm.tm_min=0;
	htm.tm_sec=0;
	htt=mktime(&htm);
	ptm=localtime(&htt);
	
	return(ptm->tm_yday); }
 	         
/* returns the unit length currently valid */
int getunitlength(time_t tt){
	int unitsecs, d, easter_sun;
	struct tm* ct;
	float h;

	/* Phone unit lengths for Austrian Telecom - hardcoded. */
	easter_sun = get_easter(localtime(&tt));
	ct = localtime(&tt);     /* localtime works a little bit curious */
	h = ct->tm_hour + ct->tm_min/60.;
	d = ct->tm_wday;

        if (       ct->tm_yday == 0                         /* 1.1., New Year */
                || ct->tm_yday == easter_sun                /* Easter sunday */
                || ct->tm_yday == easter_sun+1              /* Easter monday */
                || ct->tm_yday == easter_sun+39             /* Christi Himmelfahrt */
                || ct->tm_yday == easter_sun+49             /* Pfingstsonntag */
                || ct->tm_yday == easter_sun+50             /* Pfingstmontag */
                || (ct->tm_mday == 15 && ct->tm_mon ==7)    /* Maria Himmelfahrt */
                || (ct->tm_mday == 1 && ct->tm_mon == 4)    /* may day (1.5.) */
                || (ct->tm_mday == 26 && ct->tm_mon == 9)    /* Nationalfeiertag */  
                || (ct->tm_mday == 25 && ct->tm_mon == 11)  /* 1. Weihnachtsfeiertag */ 
                || (ct->tm_mday == 26 && ct->tm_mon == 11)  /* 2. Weihnachtsfeiertag */ 
		)
	  d = 9;
                        
	  if (d == 9){           /* Feiertage */
	    if (h < 8)
	      unitsecs = AT_NACHT;
	    if (h >= 8 &&  h < 18)
	      unitsecs = AT_TAG;
	    if (h >= 18 )
	      unitsecs = AT_NACHT;
	  } else {

	    if (d == 0 || d == 6){  /* Samstag oder Sonntag */ 
		unitsecs = AT_NACHT;
	    } else {	    
	                            /* Werktage */
	      if (h < 8)
		unitsecs = AT_NACHT;
	      if (h >= 8 &&  h < 18)
		unitsecs = AT_TAG;
	      if (h >= 18 )   
		unitsecs = AT_NACHT;
	    }}
	
	return unitsecs;
}
