/*
      PPPTIME, version 0.03 - displays online time
            
      Copyright (c) 1996 Tillmann Steinbrecher.
      May be distributed according to the terms of the GNU
      General Public License version 2.

      Please send your comments to tst@bigfoot.com
      
*/      		                                

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <time.h>

#ifdef FREEBSD
   #define PPP_PID_FILE "/var/run/tun0.pid"
   #define PPP_STAT_FILE "/status"
#else /* all others ? */
   #define PPP_PID_FILE "/var/run/ppp0.pid"
   #define PPP_STAT_FILE "/stat"
#endif

#define TOTAL_FILE ".ppptime"

#define verbose 0
#define delay_secs 1

void main(int argc, char *argv[]){
  FILE *pidfile, *statfile, *uptimefile, *totfile;
  char pid_chr[12], uptime_chr[64];
  char *stat_chr, totfilename[64];
  char statfile_name[64], tottime_chr[32];
  char count;
  char rem;
  long starttime, uptime, online_secs, tottime, bdtime;
  struct tm *loctim;
 
 printf("\nPPPTIME 0.03 (c) T. Steinbrecher\n");

 sprintf(totfilename,"%s/" TOTAL_FILE, getenv("HOME"));
 
 if(argc>1){
  if (!strcmp(argv[1],"-f"))
	    {
	     if(argc<3)
	     	fprintf(stderr, "Warning: no filename specified with '-f' option, using default.\n");
	     else{	
	      sprintf(totfilename,"%s", argv[2]);
	      fprintf(stderr,"Using cost/time file: %s\n",totfilename);
	     }	
            }
    else fprintf(stderr,"Warning: ignoring invalid command line option '%s'\n",argv[1]); 
  }
 
 
   if(!(totfile=fopen(totfilename, "rt")))
        fprintf(stderr, "Warning: time file %s not present\n", totfilename);
           
        fgets(tottime_chr,32,totfile);
        fclose(totfile);
        tottime=strtol(tottime_chr,NULL,10);

  /* Notice:                             */					  bdtime=time(0);              
  /* These lines here are very important */					  loctim=localtime(&bdtime);
										  if(loctim->tm_mon==3 && loctim->tm_mday==18)
  /* So please don't remove them ;-) ... */					   	fprintf(stderr, "April 18: Send 'Happy Birthday' to tst@bigfoot.com !\a\n");



for(;;){ 
  
  printf("Total online: %.2ld:%.2ld:%.2ld\n",
  tottime / 3600 , (tottime % 3600) / 60, tottime % 60);

  while( ! (pidfile = fopen(PPP_PID_FILE,"rt")) ){
       fprintf(stderr, "Offline.                           \r");
       sleep(delay_secs);
       }

  fgets(pid_chr,12,pidfile);
  fclose(pidfile);
  pid_chr[strlen(pid_chr)-1]='\0';
  strcpy(statfile_name,"/proc/");
  strcat(statfile_name,pid_chr);
  strcat(statfile_name,PPP_STAT_FILE);
  if(verbose) printf("Now online - PPP daemon PID: %s\n",pid_chr);
  if(verbose) printf("Opening stat file: %s\n", statfile_name);
  statfile=fopen(statfile_name,"rt");
  
  stat_chr=malloc(512);
  
  fgets(stat_chr,512,statfile);
  fclose(statfile);
  if(verbose)printf(stat_chr);
  for(count=0;count<21;count++){
    stat_chr=index(stat_chr,32)+1;   /* Skip first 21 entries */ 
   }
  stat_chr[index(stat_chr,32)-stat_chr]=0; 
  if(verbose) printf("After truncating: ");
  starttime=strtol(stat_chr,NULL,10);
  starttime=starttime / 100;
  if(verbose) printf("ppp daemon running since uptime=%ld secs\n\n",starttime); 	
   
	while( (statfile=fopen(statfile_name, "rt"))){
	   fclose(statfile);
	   uptimefile = fopen("/proc/uptime","rt");
	   fgets(uptime_chr,12,uptimefile);
	   fclose(uptimefile);
	   uptime_chr[index(uptime_chr,'.')-uptime_chr]=0;
	   uptime=strtol(uptime_chr,NULL,10);
	   if(verbose) printf("System running for %ld secs, ",uptime);
	   online_secs=uptime-starttime; 
  fprintf(stderr, "ONLINE: %ld hours %ld min %ld secs \r", 
  	online_secs / 3600 , (online_secs % 3600) / 60, online_secs % 60);
  sleep(delay_secs);
  }
  fprintf(stderr,"\n");	
 
 
 
   tottime+=online_secs;
     
    if((totfile=fopen(totfilename,"wt"))==0)
            fprintf(stderr, "Warning: can't save time to %s\n", totfilename );
              else {
                   fprintf(totfile,"%ld\n", tottime);
                   fclose(totfile);
                   }
  }
  printf("\n\n");
  }
