#!/usr/bin/perl

##############################################
#
# Ermittlung der Zeiten vom Abheben
# der Gegenstelle bis zum Herstellen der 
# PPP-Verbindung
#
# Copyright by Matthias Kabel
# 10.02.1999
#
# This program is redistributable under the GNU GPL
# 
##############################################

use Time::Local;

print "$ARGV[0]\n";

$logfilename = $ARGV[0];
print "$logfilename\n";
   
$logfilename = "/var/log/messages" unless defined $ARGV[0];
open(INFH, "<$logfilename") || die "Die $logfilename konnte nicht geffnet werden.\n";


$busy = 0;
$no_carrier = 0;
$no_dialtone = 0;
$verbindungsanzahl = 0;

while (<INFH>) {
  test() if  /expect \(CONNECT\)$/;
  verbindung() if /Connect: ppp0 <-->/;
  $no_carrier++ if /NO CARRIER$/;
  $busy++ if /BUSY$/;
  $no_dialtone++ if /NO DIALTONE$/;
}
close(INFH);

print "Es wurden $verbindungsanzahl Verbindungen zum Provider ausgewertet:\n\n";
$summe = 0;
for ($i=0;$i<$verbindungsanzahl;$i++){
	$summe += $verbindungszeiten[$i];
	print "$i\t$verbindungszeiten[$i] s\n";
	}
print "===================\n";

@verbindungszeiten = sort @verbindungszeiten;
print "\nMittelwert:\t", $summe/$i," s\n";
print "Minimum:\t", $verbindungszeiten[0]," s\n";
print "Maximum:\t", $verbindungszeiten[$#verbindungszeiten]," s\n";
print "\nBUSY:\t", $busy,"\n" if $busy >0;
print "\nNO DIALTONE:\t", $no_dialtone,"\n" if $no_dialtone >0;
print "\nNO CARRIER:\t", $no_carrier,"\n" if $no_carrier >0;

sub test {
  $verbindungsaufbau = 1;
  $_ =~ /(\w+)\s*(\d+)\s*(\d\d):(\d\d):(\d\d)(.*$)/;
  $einwahlzeit = timelocal($5,$4,$3,$2.$1);

}

sub verbindung {
    $_ =~ /(\w+)\s*(\d+)\s*(\d\d):(\d\d):(\d\d)(.*$)/;
  	$verbindungszeit = timelocal($5,$4,$3,$2,$1);
	$einwahldauer = $verbindungszeit- $einwahlzeit;
	$verbindungszeiten[$verbindungsanzahl] = $einwahldauer;
	$verbindungsanzahl++;	 
}
