#include "xppp_init.h"
#include "mytokens.h"
#include <ctype.h>
#include <string.h>
#include <stdio.h>

int postHandler(FL_OBJECT *obj, int event, FL_Coord myX, FL_Coord myY, int key, void *xev)
{
  char *a;
  if (obj==pro1)
	a="Enter here the prompt which\nyour ISP asks your username with.";
  else if (obj==pro2)
	a="Enter here the prompt which\nyour ISP asks your password with.";
  else if (obj==ans1)
	a="Enter here your username.";
  else if(obj==ans2)
	a="Enter here your password.\n(invisible).";
  else if (obj==ans22)
	a="Enter again your password.";
  else if (obj==pro3)
	a="Enter here any prompt that your ISP\nissues you after identifying.\nIn my case is a \'>\'";
  else if (obj==ans3)
	a="Answer to the extra prompt.\nIn my case is a \'ppp\'";
  else if (obj==locI)
	a="Local IP\nLeave 0.0.0.0 for\ndynamic IP assignament.";
  else if (obj==remI)
	a="Remote IP\nLeave 0.0.0.0 for\ndynamic IP assignament.";
  else if (obj==netI)
	a="Netmask\nAdecuate this to your network class.\n255.255.255.0 should work fine.";
  else if (obj==aonoiB)
	a="Leave ON for dynamic IP asignament.";
  else if (obj==aodefB)
	a="Leave ON to add the ISP's address\nto your kernel routing table\nas default getaway.";
  else if (obj==aotimI)
	a="Timeout to wait\nfor connection (seconds).";
  else if (obj==aortsB)
	a="Leave ON to use hardware\nRTS/CTS flow control.";
  else if (obj==aoasyI)
	a="Caracters that can not be transmitted.\nDo not change if not sure!";
  else if (obj==aoescI)
	a="Escape secuences.\nDo not change if not sure!";
  else if (obj==genB)
	a="Press to generate the \nppp connection script.";
  else if (obj==advB)
	a="Press to set some\ncommunication options.";
  else if (obj==ipaB)
	a="Press to set\n IP options";
  else
	a="Sorry, feature not implemented yet.\nIf you need it, contact the author.";

  if (event==FL_ENTER)
	fl_show_oneliner(a, obj->form->x + obj->x , obj->form->y + obj->y + obj->h + 1);
  else
	if (event!=FL_MOTION)
		fl_hide_oneliner();
	
}

void initXppp()
{
   if(parsed)
   {
	fl_set_input(pro1,"Username:");
	fl_set_input(pro2,"Password:");

	if (strlen(options[0]))
		fl_set_input(phone,options[0]);
	if (strlen(options[1]))
		fl_set_input(pro1,options[1]);
	if (strlen(options[2]))
		fl_set_input(ans1,options[2]);
	if (strlen(options[3]))
		fl_set_input(pro2,options[3]);
	if (strlen(options[4]))
	{
		fl_set_input(ans2,options[4]);
		fl_set_input(ans22,options[4]);
	}
	if (strlen(options[5]))
		fl_set_input(pro3,options[5]);
	if (strlen(options[6]))
		fl_set_input(ans3,options[6]);
	if (strlen(options[7]))
		fl_set_input(pro4,options[7]);
	if (strlen(options[8]))
		fl_set_input(ans4,options[8]);

   }
   else
   {
	fl_set_input(pro1,"Username:");
	fl_set_input(pro2,"Password:");
   }
	fl_set_object_posthandler(pro1,postHandler);
	fl_set_object_posthandler(pro2,postHandler);
	fl_set_object_posthandler(ans1,postHandler);
	fl_set_object_posthandler(ans2,postHandler);
	fl_set_object_posthandler(ans22,postHandler);
	fl_set_object_posthandler(pro3,postHandler);
	fl_set_object_posthandler(ans3,postHandler);
	fl_set_object_posthandler(ipaB,postHandler);
	fl_set_object_posthandler(advB,postHandler);
	fl_set_object_posthandler(genB,postHandler);
}

void initIPa()
{
   if(parsed)
   {
	if (strlen(options[9]))
		fl_set_input(locI,options[9]);
	else
		fl_set_input(locI,"0.0.0.0");
	if (strlen(options[10]))
		fl_set_input(remI,options[10]);
	else
		fl_set_input(remI,"0.0.0.0");
	if (strlen(options[11]))
		fl_set_input(netI,options[11]);
	else
		fl_set_input(netI,"255.255.255.0");
	if(strlen(options[22]))
		fl_set_input(preI,options[22]);
	if(strlen(options[23]))
		fl_set_input(preI,options[23]);
	
   }
   else
   {
	fl_set_input(locI,"0.0.0.0");
	fl_set_input(remI,"0.0.0.0");
	fl_set_input(netI,"255.255.255.0");
   }

   fl_set_object_posthandler(locI,postHandler);
   fl_set_object_posthandler(remI,postHandler);
   fl_set_object_posthandler(netI,postHandler);
   fl_set_object_posthandler(aonoiB,postHandler);
   fl_set_object_posthandler(aodefB,postHandler);

   fl_set_object_posthandler(preI,postHandler);
   fl_set_object_posthandler(posI,postHandler);
   fl_deactivate_object(preI);//temporal
   fl_deactivate_object(posI);//temporal
}


void initAo()
{
   if(parsed)
   {
	fl_set_button(s115,0);
	fl_set_button(s57,0);
	fl_set_button(s38,0);
	fl_set_button(s19,0);
	fl_set_button(s9,0);
	fl_set_button(soth,0);
	fl_deactivate_object(aospeI);

	fl_set_button(aopulB,0);
	fl_set_button(aotonB,0);

	fl_set_button(aovol0,0);
	fl_set_button(aovol1,0);
	fl_set_button(aovol2,0);
	fl_set_button(aovol3,0);

	if (strlen(options[12]))
		fl_set_input(aodevI,options[12]);
	else
		fl_set_input(aodevI,"/dev/modem");
	if (strlen(options[13]))
	{
		if (!strcmp(options[13],"115200"))
			fl_set_button(s115,1);
		else if (!strcmp(options[13],"57600"))
			fl_set_button(s57,1);
		else if (!strcmp(options[13],"38400"))
			fl_set_button(s38,1);
		else if (!strcmp(options[13],"19200"))
			fl_set_button(s19,1);
		else if (!strcmp(options[13],"9600"))
			fl_set_button(s9,1);
		else
		{
			fl_activate_object(aospeI);
			fl_set_input(aospeI,options[13]);
			fl_set_button(soth,1);
		}
	}
	else
	{
		fl_set_button(s115,1);
	}
	if (strlen(options[14]))
		fl_set_input(aotimI,options[14]);
	else
		fl_set_input(aotimI,"30");
	if (strlen(options[15]))
		if (!strcmp(options[15],"P"))
			fl_set_button(aopulB,1);
		else
			fl_set_button(aotonB,1);
	else
		fl_set_button(aotonB,1);
	if (strlen(options[16]))
		if (!strcmp(options[16],"L0"))
			fl_set_button(aovol0,1);
		else if (!strcmp(options[16],"L3"))
			fl_set_button(aovol3,1);
		else if (!strcmp(options[16],"L2"))
			fl_set_button(aovol2,1);
		else
			fl_set_button(aovol1,1);
	else
		fl_set_button(aovol1,1);
	
	if (strlen(options[17]))
		fl_set_button(aortsB,1);
	else
		fl_set_button(aortsB,0);

	if (strlen(options[18]))
		fl_set_input(aoasyI,options[18]);
	else
		fl_set_input(aoasyI,"");
	if (strlen(options[19]))
		fl_set_input(aoescI,options[19]);
	else
		fl_set_input(aoescI,"");
	if (strlen(options[20]))
		fl_set_button(aonoiB,1);
	else
		fl_set_button(aonoiB,0);
	if (strlen(options[21]))
		fl_set_button(aodefB,1);
	else
		fl_set_button(aodefB,0);
   }
   else
   {
		/*	device, timeout		*/
	fl_set_input(aodevI,"/dev/modem");
	fl_set_input(aotimI,"30");
		/*  	connection speed 	*/
	fl_set_button(s115,1);
	fl_set_button(s57,0);
	fl_set_button(s38,0);
	fl_set_button(s19,0);
	fl_set_button(s9,0);
	fl_set_button(soth,0);
	fl_set_input(aospeI,"");
	fl_deactivate_object(aospeI);
		/*	asyncmap , escape	*/
	fl_set_input(aoasyI,"20A0000");
	fl_set_input(aoescI,"FF");
		/*	dialing mode		*/
	fl_set_button(aotonB,1);
	fl_set_button(aopulB,0);
		/*	speaker volume		*/
	fl_set_button(aovol0,0);
	fl_set_button(aovol1,1);
	fl_set_button(aovol2,0);
	fl_set_button(aovol3,0);
		/*	flow ctrl, noipdefault, defaultroute	*/
	fl_set_button(aortsB,1);
	fl_set_button(aonoiB,1);
	fl_set_button(aodefB,1);

   }

   fl_set_object_posthandler(aotimI,postHandler);
   fl_set_object_posthandler(aortsB,postHandler);
   fl_set_object_posthandler(aoasyI,postHandler);
   fl_set_object_posthandler(aoescI,postHandler);
}


void initLaunch()
{
   int flag=0;
	//if temporal file exists, delete it.
  if((aux=fopen(temporal,"r")))
  {
	char tmp[255];
	sprintf(tmp,"rm %s",temporal);
	fclose(aux);
	fl_exe_command(tmp,1);
  }

// search for configuration files : xppprc , specific.xppprc , specific.ppp-init
// and specific.ppp-on-dialer

  //first : xppprc
  if(!(xppprc=fopen(configrc,"r")))
  {
	char tmp[255];
	sprintf(tmp,"Couldn't open configuration file: %s",configrc);
	fl_show_alert(tmp,"Please configurate your connection first. (Configurate button)","",0);
	flag=1;
  }
  else
  {
	char tmp[255];
	fscanf(xppprc,"%s",tmp);
	if (!strlen(tmp))		//does it contain data ?
	{
		char tmp[255];
		sprintf(tmp,"Corrupted data in configuration file : %s",configrc);
		fl_show_alert(tmp,"Couldn't get info.","Please configurate your connection first. (Configurate button)",0);
		flag=1;

	}
	else				//yes, it contains data
	{
		strcpy(specific,tmp);
		if(!(spec=fopen(specific,"r")))	//can specific file be opened
		{
			char tmp[255];
			sprintf(tmp,"Couldn't open config file : %s",specific);
			fl_show_alert(tmp,"","Please configurate your connection first. (Configurate button)",0);
			flag=1;
		}
		else				// yes
		{
			char a[255],*b;
			/*search for PPP_SCRIPT*/
			fgets(a,250,spec);
			//printf("%s-",a); //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1
			if( !(getToken(tmp,a,"PPP_SCRIPT=")) )	//1st label ?
			{
				char tmp[255];
				sprintf(tmp,"Corrupted data in configuration file : %s",specific);
				fl_show_alert(tmp,"PPP_SCRIPT   line not found.","Please configurate your connection first. (Configurate button)",0);
				flag=1;
			}
			else							// Yes
			{
				removeToken(pppScript,tmp,'\n'); //tiene un newline de mas
				//printf("%s - %s\n",b,pppScript);

								/*search for DIAL_SCRIPT*/
				fgets(a,250,spec);
				//printf(a);//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!11
				if( !(getToken(tmp,a,"DIAL_SCRIPT=")) )
				{
					char tmp[255];
					sprintf(tmp,"Corrupted data in configuration file : %s",specific);
					fl_show_alert(tmp,"DIAL_SCRIPT   line not found.","Please configurate your connection first. (Configurate button)",0);
					flag=1;
				}
				else				//Yes
				{
					removeToken(dialScript,tmp,'\n');//sacar newline
					//printf("%s - %s\n",tmp,dialScript);
					//printf("%d - %s-",ppps,pppScript);
					if (!(ppps=fopen(pppScript,"r")))
					{
						fl_show_alert("ppp script not found !",pppScript,"Please configurate your connection first. (Configurate button)",0);
						flag=1;
					}
					else
					{
						if (!(dials=fopen(dialScript,"r")))
						{
							fl_show_alert("dialing script not found !",dialScript,"Please configurate your connection first. (Configurate button)",0);
							flag=1;
						}
						else
						{
							char tmp[255],aux[255];
							fgets(tmp,200,spec);
							if(!getToken(aux,tmp,"CONNAME="))
							{
								char tmp[255];
								sprintf(tmp,"Corrupted data in configuration file : %s",specific);
								fl_show_alert(tmp, "CONNAME   line not found.","Please configurate your connection first. (Configurate button)",0);
								flag=1;
							}
							else
							{
								removeToken(conname,aux,'\'');
							}
						}//dial script opened
					}// ppp script opened
				}// DIAL_SCRIPT found in specific
			}// PPP_SCRIPT found in specific

			fclose(spec);

		}//sspecific file opened OK
	}//xppprc contains data

  	fclose(xppprc);

  }// file opened OK

  if (flag)
  {
	fl_deactivate_object(cconnB);
	strcpy(conname,"Connection1");
	strcpy(specific,"conn1.xppprc");
  }
  else
  {
		/*Everyting OK*/
	char text[255], result[255];
	int i;
	fl_set_object_label(ppptext,specific);
	fl_set_object_label(dialtext,conname);
	/*Here comes the loading of data from scripts (I hope...)*/
	/*ppp script first*/
	while(!feof(ppps))
	{
		fgets(text, 250,ppps);
		if(!beginsWith(text,'#'))
		{
			//printf("%s\n",text);
			for(i=0;i<24;i++)
			if(getToken(result,text,variables[i]))
			{
				removeToken(options[i],result,'\'');
				//printf(" - %s --- %s\n",text, options[i]);
			}
		}


	}

  fclose(ppps);
  fclose(dials);
  parsed=1;
  }

  fl_set_pixmap_file(mysite,xpmmysite);
  fl_set_pixmap_file(myISP,xpmmyISP);
  fl_set_pixmap_file(phoneline,xpmnoline);

  fl_deactivate_object(cdisB);




/*These are temporal hidings ... */

  fl_deactivate_object(cselB);
  fl_hide_object(cselB);


/*End Of Temporal hidings*/

}



void restoreIPa()
{
	initIPa();	//TODO !!!!!!!!!!!!!
}

void restoreAo()
{
	initAo();	//TODO !!!!!!!!!!!!!
}




void initializeForms()
{
	int i;
	parsed=0;
	mutex=1;
  	for (i=0;i<22;i++)
		strcpy(options[i],"\0");

	strcpy(variables[0],"PHONE=");
	strcpy(variables[1],"PROMPT1=");
	strcpy(variables[2],"USERNAME=");
	strcpy(variables[3],"PROMPT2=");
	strcpy(variables[4],"PASSWORD=");
	strcpy(variables[5],"PROMPT3=");
	strcpy(variables[6],"ANSWER3=");
	strcpy(variables[7],"PROMPT4=");
	strcpy(variables[8],"ANSWER4=");
	strcpy(variables[9],"LOCALIP=");
	strcpy(variables[10],"REMOTEIP=");
	strcpy(variables[11],"NETMASK=");
	strcpy(variables[12],"DEVICE=");
	strcpy(variables[13],"SPEED=");
	strcpy(variables[14],"TIMEOUT=");
	strcpy(variables[15],"DIALMODE=");
	strcpy(variables[16],"VOLUME=");
	strcpy(variables[17],"FLOWCTRL=");
	strcpy(variables[18],"ASYNCMAP=");
	strcpy(variables[19],"ESCAPE=");
	strcpy(variables[20],"NOIPDEFAULT=");
	strcpy(variables[21],"DEFAULTROUTE=");
	strcpy(variables[22],"PRECOMMAND=");
	strcpy(variables[23],"POSTCOMMAND=");

	strcpy(dirname,"/usr/local/lib/xdialppp");
	sprintf(fname1,"%s/ppp-init",dirname);
	sprintf(fname2,"%s/ppp-on-dialer",dirname);
	sprintf(configrc,"%s/xppprc",dirname);
	sprintf(temporal,"%s/xppptmp",dirname);
	sprintf(disconn,"%s/ppp-off",dirname);
	sprintf(messages,"/var/log/messages");

	sprintf(xpmline0,"%s/pix/line0.xpm",dirname);
	sprintf(xpmline1,"%s/pix/line1.xpm",dirname);
	sprintf(xpmline2,"%s/pix/line2.xpm",dirname);
	sprintf(xpmline3,"%s/pix/line3.xpm",dirname);
	sprintf(xpmline4,"%s/pix/line4.xpm",dirname);
	sprintf(xpmline5,"%s/pix/line5.xpm",dirname);
	sprintf(xpmline6,"%s/pix/line6.xpm",dirname);
	sprintf(xpmline7,"%s/pix/line7.xpm",dirname);
	sprintf(xpmdial0,"%s/pix/dialing0.xpm",dirname);
	sprintf(xpmdial1,"%s/pix/dialing1.xpm",dirname);
	sprintf(xpmdial2,"%s/pix/dialing2.xpm",dirname);
	sprintf(xpmmysite,"%s/pix/mysite.xpm",dirname);
	sprintf(xpmmyISP,"%s/pix/myISP.xpm",dirname);
	sprintf(xpmnoline,"%s/pix/phoneline.xpm",dirname);
	sprintf(xpmdaemon,"%s/pix/pppdaemon.xpm",dirname);


	initLaunch();
	initXppp();
	initIPa();
	initAo();
}


int  checknum(char * myStr)
{
   char copied[80];
   int flag=0,i=0,clen;
   strcpy(copied,myStr);
   clen=strlen(copied);
   while( i<clen && isdigit(copied[i]) )
	i++;
   if (i==clen)
	return 1;
   else
	return 0;
}

int  isIP(char * myStr)
{
  char copied[80],*a,*b,*c,*d;
  int flag=0,i;
  strcpy(copied,myStr);
  a=strtok(copied,".");
  b=strtok(NULL,".");
  c=strtok(NULL,".");
  d=strtok(NULL,".");
  if (a!=NULL && b!=NULL && c!=NULL && d!=NULL)
  	if (checknum(a) && checknum(b) && checknum(c) && checknum(d))
		if( (atol(a) < 256) && (atol(b) < 256) && (atol(c) < 256) && (atol(d) < 256) )
  			return 1;
  return 0;
}


void doStop(char* message, FL_FORM* whichForm)
{
	fl_set_object_label(stext, message);
	lastDeactForm=whichForm;
	fl_deactivate_form(lastDeactForm);
	fl_show_form(stoping,1,1,"Xdialppp Stop");
}





