#include <stdio.h>
#include <string.h>

#include "mytokens.h"

/*  -------------------------------------------------------------------------
	findSubStr(const char *thestring, const char *pattern)
 
		function :
			tries to find pattern in thestring
		return :
			the position where the pattern finishes + 1 if pattern 
				is found in thestring
			-1 else
    ------------------------------------------------------------------------- */

int findSubStr(const char *thestring, const char *pattern)
{
   int i,j,count,slen,plen;
   slen=strlen(thestring);
   plen=strlen(pattern);
   i=j=count=0;
   if (plen==0 || slen==0)
	return -1;
   while(i<slen && j<plen && count!=plen)
   {
	if(thestring[i]==pattern[j])
	{
	    j++;
	    count++;
	}
	else
	{
	    count=0;
	    j=0;
	}
  	i++;
   }
   if (count==plen)
	return i;
   else 
	return -1;
}


/*  -------------------------------------------------------------------------
	getToken(const char *message, const char *prompt)
 
		function :
			Returns a pointer to the string starting at the
			point where prompt finishes.
		return :
			a char *
			NULL if prompt is not found
		How the hell do you use it ?
			Example: you have the string "PHONE=264896"
			you call getToken(string,"PHONE=")
			and returns 264896
    ------------------------------------------------------------------------- */

char *getToken(char * dest, const char *message, const char *prompt)
{
 const char *a;
 char *b=dest;
 int c,i;
 int mlen,plen;
 mlen=strlen(message);
 plen=strlen(prompt);
 if (mlen==0 || plen==0)
	return NULL;
 if((c=findSubStr(message,prompt))!=-1)
 {
	a=message;
	for(i=0;i<c;i++)
		a++;
	sscanf(a,"%s",b);
	return b;
 }
 else
	return NULL;
}



int beginsWith(const char *message, char c)
{
 if (message[0]==c)
	return 1;
 else
	return 0; 
}


char * removeToken(char * dest, char *mystring, char c)
{
 int i,j,slen;
 char *b=dest;
 slen=strlen(mystring);
 j=0;
 for(i=0;i<slen;i++)
 {
	if (mystring[i]!=c)
	{
		b[j]=mystring[i];
		j++;
	}
 }
 b[j]=0;
 return b;
}
