//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

/***********************************************
** Source Dump From QtEZ http://qtez.zax.net/qtez
** ---------------------------------------------
** Dumped: Wed Nov 18 19:34:59 1998
**     To: .//Kpppsvr.cpp
**     By: mark
***********************************************/

#include "./Kpppsvr.h"

Kpppsvr::Kpppsvr(QWidget *, char *name) 
	: KTopLevelWidget(name)
{
	setCaption("Kpppsvr");
	resize(270,220);

	QFrame *vmain = new QFrame(this,"main");
	
	m_buttonD = new QPushButton(this, "m_buttonD");
	m_buttonD->setText("Stop PPP");
	m_buttonD->setGeometry(20,50,100,25);
	
	m_buttonU = new QPushButton(this, "m_buttonU");
	m_buttonU->setText("Start PPP");
	m_buttonU->setGeometry(20,20,100,25);
	
	m_buttonR = new QPushButton(this, "m_buttonR");
	m_buttonR->setText("Restart PPP");
	m_buttonR->setGeometry(20,80,100,25);
	
	m_buttonK = new QPushButton(this, "m_buttonK");
	m_buttonK->setText("Keep-Alive On");
	m_buttonK->setGeometry(20,110,100,25);
	
	m_buttonZ = new QPushButton(this, "m_buttonZ");
	m_buttonZ->setText("Keep-Alive Off");
	m_buttonZ->setGeometry(20,140,100,25);
	
	m_buttonT = new QPushButton(this, "m_buttonT");
	m_buttonT->setText("Kill Server");
	m_buttonT->setGeometry(20,170,100,25);
	
	m_buttonO = new QPushButton(this, "m_buttonO");
	m_buttonO->setText("Proxy Online");
	m_buttonO->setGeometry(150,20,100,25);
	
	m_buttonL = new QPushButton(this, "m_buttonL");
	m_buttonL->setText("Proxy Offline");
	m_buttonL->setGeometry(150,50,100,25);
	
	m_buttonF = new QPushButton(this, "m_buttonF");
	m_buttonF->setText("Proxy Fetch");
	m_buttonF->setGeometry(150,80,100,25);
	
	m_buttonG = new QPushButton(this, "m_buttonG");
	m_buttonG->setText("Proxy Purge");
	m_buttonG->setGeometry(150,110,100,25);
	
	m_buttonM = new QPushButton(this, "m_buttonM");
	m_buttonM->setText("Send Mail");
	m_buttonM->setGeometry(150,140,100,25);
	
	m_buttonX = new QPushButton(this, "m_buttonX");
	m_buttonX->setText("Exit kpppsvr");
	m_buttonX->setGeometry(150,170,100,25);
	
	connect(m_buttonM,SIGNAL(clicked()),SLOT(SendMail()));
	connect(m_buttonG,SIGNAL(clicked()),SLOT(ProxyPurge()));
	connect(m_buttonF,SIGNAL(clicked()),SLOT(ProxyFetch()));
	connect(m_buttonL,SIGNAL(clicked()),SLOT(ProxyOffline()));
	connect(m_buttonO,SIGNAL(clicked()),SLOT(ProxyOnline()));
	connect(m_buttonT,SIGNAL(clicked()),SLOT(KillPPP()));
	connect(m_buttonZ,SIGNAL(clicked()),SLOT(KeepAliveOff()));
	connect(m_buttonK,SIGNAL(clicked()),SLOT(KeepAliveOn()));
	connect(m_buttonR,SIGNAL(clicked()),SLOT(RestartPPP()));
	connect(m_buttonU,SIGNAL(clicked()),SLOT(StartPPP()));
	connect(m_buttonD,SIGNAL(clicked()),SLOT(StopPPP()));
	connect(m_buttonX,SIGNAL(clicked()),SLOT(ExitApp()));

	statusBar = new KStatusBar(this);
	setStatusBar(statusBar);
	statusBar->insertItem("          ",0);
	statusBar->insertItem("          ",1);
	statusBar->insertItem("          ",2);
	statusBar->insertItem(" ",3);	// last one is as big as you like 
	statusBar->enable(KStatusBar::Show);

	KApplication *app=KApplication::getKApplication();
	config=app->getConfig();
	config->setGroup("Network");
	m_hostPort = config->readNumEntry("PortNumber",PPPSVR_PORT);
	::strncpy(m_hostAddr,config->readEntry("HostAddress",PPPSVR_HOST).data(),sizeof(m_hostAddr)-1);
}


Kpppsvr::~Kpppsvr()
{
}

Kpppsvr::StartPPP()
{
	SendPPP('U');
}


Kpppsvr::StopPPP()
{
	SendPPP('D');
}


Kpppsvr::RestartPPP()
{
	SendPPP('R');
}


Kpppsvr::KeepAliveOn()
{
	SendPPP('K');
}


Kpppsvr::KeepAliveOff()
{
	SendPPP('Z');
}


Kpppsvr::KillPPP()
{
	SendPPP('T');
}


Kpppsvr::ProxyOnline()
{
	SendPPP('O');
}


Kpppsvr::ProxyOffline()
{
	SendPPP('L');
}


Kpppsvr::ProxyFetch()
{
	SendPPP('F');
}


Kpppsvr::ProxyPurge()
{
	SendPPP('G');
}


Kpppsvr::SendMail()
{
	SendPPP('M');
}

void
Kpppsvr::SendPPP(char cmd)
{
char rcmd[2],retc[5];

	statusBar->changeItem("    ",0);

	::memset(rcmd,0,sizeof(rcmd));
	::memset(retc,0,sizeof(retc));

	rcmd[0]=cmd;
	
	SocketSetup();

	::write(m_socket,rcmd,1);
	::read(m_socket,retc,4);
	::close(m_socket);

	statusBar->changeItem(retc,0);
}

void
Kpppsvr::SocketSetup()
{
struct hostent *hp,*gethostbyname();
char cmd[2];
int c;
	
	if((m_socket=::socket(AF_INET,SOCK_STREAM,0)) < 0)
	{
		::perror("opening socket");
//		exit(1);
	}
	
	::memset(&m_server,0,sizeof(m_server));
	m_server.sin_family=AF_INET;
	if(!(hp=::gethostbyname(m_hostAddr)))
	{
		::perror("host not known");
//		exit(2);
	}
	::memcpy(&m_server.sin_addr,hp->h_addr,hp->h_length);
	m_server.sin_port=htons(m_hostPort);

	if(::connect(m_socket,(struct sockaddr *)&m_server,sizeof(m_server)) < 0)
	{
		::perror("connecting socket");
//		exit(1);
	}
	
}

Kpppsvr::ExitApp()
{
	emit done();
}

