// KPPPLoad - a PPP load monitor
// Copyright (C) 1998  Sean Vyain, svyain@mail.tds.net
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <stdlib.h>

#include <qchkbox.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlined.h>

#include <kapp.h>
#include <kcolorbtn.h>
#include <kseparator.h>

#include "Options.h"
#include "OptionsDlg.h"

#include "OptionsDlg.moc"

OptionsDlg::OptionsDlg( QWidget * parent, const char* name )
        : QDialog( parent, name, TRUE )
{
    setCaption( i18n( "KPPPLoad: Options" ) );
    setIconText( i18n( "KPPPLoad: Options" ) );

    resize( 350, 350 );

    QGroupBox* statusGroup = new QGroupBox( i18n( "Status Bar" ), this );

    _txRate = new QCheckBox( i18n( "TX Rate" ), statusGroup );
    _txRate->setFixedHeight( _txRate->sizeHint().height() );

    _rxRate = new QCheckBox( i18n( "RX Rate" ), statusGroup );
    _rxRate->setFixedHeight( _rxRate->sizeHint().height() );

    _txTotal = new QCheckBox( i18n( "TX Total" ), statusGroup );
    _txTotal->setFixedHeight( _txTotal->sizeHint().height() );

    _rxTotal = new QCheckBox( i18n( "RX Total" ), statusGroup );
    _rxTotal->setFixedHeight( _rxTotal->sizeHint().height() );

    QGroupBox* graphingGroup = new QGroupBox( i18n( "Graphing" ), this );

    QLabel* lbl1 = new QLabel( i18n( "Statistics interval:" ), graphingGroup );
    lbl1->setFixedHeight( lbl1->sizeHint().height() );
    _statsInterval = new QLineEdit( graphingGroup );
    _statsInterval->setFixedSize( 48, _statsInterval->sizeHint().height() );
    QLabel* lbl2 = new QLabel( i18n( "secs" ), graphingGroup );
    lbl2->setFixedSize( 32, lbl2->sizeHint().height() );

    QLabel* lbl3 = new QLabel( i18n( "Statistics period:" ), graphingGroup );
    lbl3->setFixedHeight( lbl3->sizeHint().height() );
    _statsPeriod = new QLineEdit( graphingGroup );
    _statsPeriod->setFixedSize( 48, _statsPeriod->sizeHint().height() );
    QLabel* lbl4 = new QLabel( i18n( "secs" ), graphingGroup );
    lbl4->setFixedSize( 32, lbl4->sizeHint().height() );

    QLabel* lbl5 = new QLabel( i18n( "Dividing line every:" ), graphingGroup );
    lbl5->setFixedHeight( lbl5->sizeHint().height() );
    _rateDivider = new QLineEdit( graphingGroup );
    _rateDivider->setFixedSize( 48, _rateDivider->sizeHint().height() );
    QLabel* lbl6 = new QLabel( i18n( "B/s" ), graphingGroup );
    lbl6->setFixedSize( 32, lbl6->sizeHint().height() );

    QLabel* lbl7 = new QLabel( i18n( "Transmit color:" ), graphingGroup );
    lbl7->setFixedHeight( lbl7->sizeHint().height() );
    _txColor = new KColorButton( graphingGroup );
    _txColor->setFixedSize( 48, _rateDivider->sizeHint().height() );

    QLabel* lbl8 = new QLabel( i18n( "Receive color:" ), graphingGroup );
    lbl8->setFixedHeight( lbl8->sizeHint().height() );
    _rxColor = new KColorButton( graphingGroup );
    _rxColor->setFixedSize( 48, _rateDivider->sizeHint().height() );

    QLabel* lbl9 = new QLabel( i18n( "PPP command:" ), this );
    lbl9->setFixedSize( lbl9->sizeHint() );
    _pppCommand = new QLineEdit( this );
    _pppCommand->setFixedHeight( _pppCommand->sizeHint().height() );

    QLabel* lbl10 = new QLabel( i18n( "Redial PPP link every" ), this );
    lbl10->setFixedSize( lbl10->sizeHint() );
    _retryInterval = new QLineEdit( this );
    _retryInterval->setFixedSize( 32, _retryInterval->sizeHint().height() );
    QLabel* lbl11 = new QLabel( i18n( "seconds." ), this );
    lbl11->setFixedHeight( lbl11->sizeHint().height() );

    QLabel* lbl12 = new QLabel( i18n( "Periodic command:" ), this );
    lbl12->setFixedSize( lbl12->sizeHint() );
    _periodicCommand = new QLineEdit( this );
    _periodicCommand->setFixedHeight( _periodicCommand->sizeHint().height() );

    QLabel* lbl13 = new QLabel( i18n( "Run command every" ), this );
    lbl13->setFixedSize( lbl13->sizeHint() );
    _periodicInterval = new QLineEdit( this );
    _periodicInterval->setFixedSize( 32, _periodicInterval->sizeHint().height() );
    QLabel* lbl14 = new QLabel( i18n( "seconds, while link is up." ), this );
    lbl14->setFixedHeight( lbl14->sizeHint().height() );

    KSeparator* sep = new KSeparator( this );

    QPushButton* ok     = new QPushButton( i18n( "OK" )    , this );
    QPushButton* apply  = new QPushButton( i18n( "Apply" ) , this );
    QPushButton* cancel = new QPushButton( i18n( "Cancel" ), this );

    ok->setFixedSize( 80, ok->sizeHint().height() );
    apply->setFixedSize( 80, apply->sizeHint().height() );
    cancel->setFixedSize( 80, cancel->sizeHint().height() );

    connect( ok    , SIGNAL( clicked() ), this, SLOT( slotOk()     ) );
    connect( apply , SIGNAL( clicked() ), this, SLOT( slotApply()  ) );
    connect( cancel, SIGNAL( clicked() ), this, SLOT( slotCancel() ) );

    QVBoxLayout* l1 = new QVBoxLayout( this, 4, 4 );

    QHBoxLayout* l1_1 = new QHBoxLayout();
    l1->addLayout( l1_1 );
    l1_1->addStrut( 5 * _rateDivider->sizeHint().height() + 4 * 4 + 3 * 8 );
    l1_1->addWidget( statusGroup, 1 );
    l1_1->addWidget( graphingGroup, 2 );

    QHBoxLayout* l1_2 = new QHBoxLayout();
    l1->addLayout( l1_2 );
    l1_2->addWidget( lbl9 );
    l1_2->addWidget( _pppCommand, 1 );

    QHBoxLayout* l1_3 = new QHBoxLayout();
    l1->addLayout( l1_3 );
    l1_3->addSpacing( 24 );
    l1_3->addWidget( lbl10 );
    l1_3->addWidget( _retryInterval );
    l1_3->addWidget( lbl11, 1 );

    QHBoxLayout* l1_4 = new QHBoxLayout();
    l1->addLayout( l1_4 );
    l1_4->addWidget( lbl12 );
    l1_4->addWidget( _periodicCommand, 1 );

    QHBoxLayout* l1_5 = new QHBoxLayout();
    l1->addLayout( l1_5 );
    l1_5->addSpacing( 24 );
    l1_5->addWidget( lbl13 );
    l1_5->addWidget( _periodicInterval );
    l1_5->addWidget( lbl14, 1 );

    l1->addStretch( 1 );
    l1->addWidget( sep );

    QHBoxLayout* l1_6 = new QHBoxLayout();
    l1->addLayout( l1_6 );
    l1_6->addStretch( 1 );
    l1_6->addWidget( ok );
    l1_6->addWidget( apply );
    l1_6->addWidget( cancel );

    QVBoxLayout* l2 = new QVBoxLayout( statusGroup, 8, 4 );
    l2->addSpacing( 8 );
    l2->addWidget( _txRate );
    l2->addWidget( _rxRate );
    l2->addWidget( _txTotal );
    l2->addWidget( _rxTotal );
    l2->addSpacing( 1 );

    QVBoxLayout* l3 = new QVBoxLayout( graphingGroup, 8, 4 );
    l3->addSpacing( 8 );

    QHBoxLayout* l3_1 = new QHBoxLayout();
    l3->addLayout( l3_1 );
    l3_1->addWidget( lbl1, 1 );
    l3_1->addWidget( _statsInterval );
    l3_1->addWidget( lbl2 );

    QHBoxLayout* l3_2 = new QHBoxLayout();
    l3->addLayout( l3_2 );
    l3_2->addWidget( lbl3, 1 );
    l3_2->addWidget( _statsPeriod );
    l3_2->addWidget( lbl4 );

    QHBoxLayout* l3_3 = new QHBoxLayout();
    l3->addLayout( l3_3 );
    l3_3->addWidget( lbl5, 1 );
    l3_3->addWidget( _rateDivider );
    l3_3->addWidget( lbl6 );

    QHBoxLayout* l3_4 = new QHBoxLayout();
    l3->addLayout( l3_4 );
    l3_4->addWidget( lbl7, 1 );
    l3_4->addWidget( _txColor );
    l3_4->addSpacing( 36 );

    QHBoxLayout* l3_5 = new QHBoxLayout();
    l3->addLayout( l3_5 );
    l3_5->addWidget( lbl8, 1 );
    l3_5->addWidget( _rxColor );
    l3_5->addSpacing( 36 );

    l3->addStretch( 1 );

    _txRate->setChecked( options->getShowTxRate() );
    _rxRate->setChecked( options->getShowRxRate() );
    _txTotal->setChecked( options->getShowTxTotal() );
    _rxTotal->setChecked( options->getShowRxTotal() );

    QString str;
    str.sprintf( "%d", options->getStatsInterval() );
    _statsInterval->setText( str );
    str.sprintf( "%d", options->getStatsPeriod() );
    _statsPeriod->setText( str );
    str.sprintf( "%d", options->getRateDivider() );
    _rateDivider->setText( str );

    _txColor->setColor( options->getTxColor() );
    _rxColor->setColor( options->getRxColor() );

    _pppCommand->setText( options->getPPPCommand() );
    str.sprintf( "%d", options->getRetryInterval() );
    _retryInterval->setText( str );

    _periodicCommand->setText( options->getPeriodicCommand() );
    str.sprintf( "%d", options->getPeriodicInterval() );
    _periodicInterval->setText( str );
}

OptionsDlg::~OptionsDlg()
{
}

void OptionsDlg::slotOk()
{
    slotApply();
    accept();
}

void OptionsDlg::slotApply()
{
    options->setShowTxRate( _txRate->isChecked() );
    options->setShowRxRate( _rxRate->isChecked() );
    options->setShowTxTotal( _txTotal->isChecked() );
    options->setShowRxTotal( _rxTotal->isChecked() );

    options->setStatsInterval( atoi( _statsInterval->text() ) );
    options->setStatsPeriod( atoi( _statsPeriod->text() ) );
    options->setRateDivider( atoi( _rateDivider->text() ) );

    options->setTxColor( _txColor->color() );
    options->setRxColor( _rxColor->color() );

    options->setPPPCommand( _pppCommand->text() );
    options->setRetryInterval( atoi( _retryInterval->text() ) );

    options->setPeriodicCommand( _periodicCommand->text() );
    options->setPeriodicInterval( atoi( _periodicInterval->text() ) );

    options->sync();
}

void OptionsDlg::slotCancel()
{
    reject();
}
