#! /bin/sh
# install.sh	Installation script to install logtime on Linux.
# Copyright (c) 1996 by Christopher S L Heng. All rights reserved.

# $Id: install.sh 1.8 1996/10/10 15:41:19 chris Exp $ /*

# This is a quick and dirty script to install logtime. Don't scrutinize it
# too closely - I know it is neither elegant nor efficient. :-)

# Initialise our variables
bindir=/usr/local/bin
instcfgdir=/usr/local/lib/logtime
mandir=/usr/local/man/man1
datadir=$HOME/LOGTIME
# (remember to search out the other instance of /usr/doc/logtime-1.21 in
# this file if we change this to a newer version)
docsdir=/usr/doc/logtime-1.21

backupipfiles=0
docfiles="readme.txt packing.lst whatsnew.txt license.txt sample.ini"
extension=elf
helprequest=0
installbinflags='-m 755'
installdataflags='-m 644'
installprogram=install
linuxreadme="README.Linux readme.lin"
noaction=0
pppinstall=0
suffixstr="#LOGTIME_INSTALL : do not remove or modify this comment"
tempname=/etc/ppp/logtimeip$$
uninstallminver=121
uninstallname=$instcfgdir/uninstall.sh
uninstallpart2=$instcfgdir/uninst.pt2
uninstallversion=
verbose=0
version=0

# Handle command line options
for i ; do
	case $i in
		-h) helprequest=1 ;;
		-n) noaction=1 ;;
		-v) verbose=1 ;;
		-V) version=1 ;;
		-*) echo $0: Unknown option -$i ; exit 1 ;;
		*) echo $0: "Usage: install.sh [options]" ; exit 1 ;;
	esac
done

# Display version message
echo "install.sh	Installs logtime on Linux. Ver 1.21."
echo "Copyright (c) 1996 by Christopher S L Heng. All rights reserved."

# check if version message is all that is desired
if test $version != 0 ; then
	exit 0
fi

# check if help message is desired
if test $helprequest != 0 ; then
	echo "Usage: install.sh [options]"
	echo	"-h	Help. Show a short usage screen."
	echo	"-n	No action. Just go through the motions of what would have"
	echo	"	been done if install.sh had really been run, but do not "
	echo	"	actually do any copying, etc. Default is to really install."
	echo	"-v	Verbose."
	echo	"-V	Version message. Just show version message and quit."
	exit 0
fi

# Check if we are root
if test $UID && test $UID != 0 ; then
	echo "install.sh: Warning: you probably need to be root for a successful installation."
fi

# Check if we have grep and install
if test ! -x /usr/bin/grep && test ! -x /bin/grep && test ! -x /usr/local/bin/grep ; then
	echo "install.sh: grep is needed for this installation script to work"
	exit 1
fi
if test ! -x /usr/bin/install && test ! -x /bin/install && test ! -x /usr/local/bin/install ; then
	echo "install.sh: install is needed for this installation script to work"
	exit 1
fi

# If we are running in interactive mode (default), we have to prompt the
# user for all the information we need.
echo
echo "This installation script will guide you through the installation"
echo "process for installing logtime on your Linux system. It will not"
echo "install logtime for Windows. You can abort the installation at"
echo "any time by hitting Control-C."
echo
echo -n "Proceed? (y/n) [y] "
read reply
echo
if test $reply && test $reply != y && test $reply != Y ; then
	echo "Installation aborted."
	exit 0
fi
echo
echo "logtime comes in two binary formats, the ELF format and the a.out format"
echo "You can only run the ELF binary if you have the ELF shared libraries"
echo "installed. Similarly, you can only run the a.out binary if you have the"
echo "a.out shared libraries installed. If you have both, install the ELF binary."
echo
echo -n "Install the ELF format? (y/n) [y] "
read reply
echo
if test ! $reply || test $reply = y || test $reply = Y ; then
	echo "Selecting the ELF format."
	extension=elf
else
	echo "Selecting the a.out format."
	extension=out
fi
echo
echo "By default, the logtime binary will be installed in $bindir."
echo "If this is not acceptable, enter a new directory to install into,"
echo "otherwise just hit the ENTER key to accept the default."
echo
echo -n "Install binary to: [$bindir] "
read reply
echo
if test $reply ; then
	bindir=$reply
fi
echo "The logtime binary will be installed in $bindir."
echo
echo "By default, the logtime manual will be installed in $mandir."
echo "If this is not acceptable, enter a new directory to install into,"
echo "otherwise, just hit the ENTER key to accept the default."
echo
echo -n "Install manual to: [$mandir] "
read reply
echo
if test $reply ; then
	mandir=$reply
fi
echo "The logtime manual page will be installed in $mandir."
echo
echo "By default, the logtime uninstall scripts will be installed in"
echo "$instcfgdir. If this is not acceptable, enter a new"
echo "directory to install into, otherwise, just hit the ENTER key to"
echo "accept the default."
echo
echo -n "Install uninstall scripts to: [$instcfgdir] "
read reply
echo
if test $reply ; then
	instcfgdir=$reply
fi
echo "The logtime uninstall scripts will be installed in $instcfgdir."
echo
echo "logtime will need a directory to keep its data and configuration files."
echo "By default, this is $datadir. If this is not acceptable,"
echo "enter a new directory; otherwise just hit the ENTER key to accept"
echo "the default."
echo "(Note: this will only be used if you are installing logtime for use"
echo "with PPP. If you are using logtime with SLIP, you will have to do"
echo "your own modification of your SLIP script files.)"
echo
echo -n "Data directory: [$datadir] "
read reply
echo
if test $reply ; then
	datadir=$reply
fi
echo "logtime will use the data directory $datadir"
echo
echo "The documentation files other than the manual page will be copied to"
echo "$docsdir. If this is not acceptable, enter a new"
echo "directory; otherwise hit the ENTER key to accept the default."
echo
echo -n "Documentation directory: [$docsdir] "
read reply
echo
if test $reply ; then
	docsdir=$reply
fi
echo
echo "If you are using PPP (with pppd), this install script is able to modify"
echo "/etc/ppp/ip-up and /etc/ppp/ip-down automatically, if you like."
echo "If you are upgrading from a previous version of logtime, or have"
echo "manually modified /etc/ppp/ip-up and /etc/ppp/ip-down to run logtime,"
echo "you will need to check your ip-up and ip-down files after this"
echo "installation and remove your original line which ran logtime. (Do not"
echo "remove the line inserted by this script; remove your manually inserted"
echo "line. The line inserted by this script can be automatically removed"
echo "by the uninstall.sh script, but your manual insertion cannot.)"
echo
echo -n "Modify /etc/ppp/ip-up and /etc/ppp/ip-down? (y/n) [y] "
read reply
echo
if test ! $reply || test $reply = y || test $reply = Y ; then
	echo "/etc/ppp/ip-up and /etc/ppp/ip-down will be modified."
	pppinstall=1
else
	echo "The /etc/ppp/ scripts will not be modified."
	pppinstall=0
fi
echo "Now installing logtime..."
echo

# First remove the old versions of logtime. We use the uninstall.sh
# previously installed in $instcfgdir if any
echo "Removing old versions of logtime and manual pages if any."

# See if an uninstall.sh script exists in $instcfgdir and if so use that.
if test -f $uninstallname ; then
	if test $noaction != 0 ; then
		uninstallnoaction=-n
	fi
	if test $verbose != 0 ; then
		uninstallverbose=-v
	fi
	uninstallversion=`$uninstallname -T`
	if test $? = 0 ; then
		if test $uninstallversion -ge $uninstallminver ; then
			nouninstallppp=-p
			backupipfiles=1
		fi
	fi
	if test $verbose != 0 ; then
		echo $uninstallname -d $nouninstallppp $uninstallnoaction $uninstallverbose
	fi
	if test $noaction = 0 ; then
		$uninstallname -d $nouninstallppp $uninstallnoaction $uninstallverbose
	fi
else
	# No uninstall script. Do a manual removal. We assume that either
	# no logtime was previously installed or logtime version 1.0 was
	# installed. We thus only remove logtime binaries and the logtime
	# unformatted and formatted manual pages, but don't touch the
	# /usr/doc directories since logtime 1.0 did not have an installation
	# program that created that. If you created one, you will have to
	# manually uninstall it.
	# Problem is that everyone seems to have their own ideas of where
	# to put the formatted manual pages as well as compress them
	# differently (.Z, .z, .gz, etc). So we wipe out everything that
	# starts with logtime.1 (ugh!).
	if test $verbose != 0 ; then
		echo "rm -f /usr/local/bin/logtime /usr/bin/logtime"
		echo "rm -f /usr/local/man/man1/logtime.1 /usr/man/man1/logtime.1"
		echo "rm -f /usr/local/man/cat1/logtime.1* /usr/man/cat1/logtime.1*"
		echo "rm -f /var/catman/cat1/logtime.1* /var/catman/local/cat1/logtime.1*"
	fi
	if test $noaction = 0 ; then
		rm -f /usr/local/bin/logtime
		rm -f /usr/local/man/man1/logtime.1 /usr/man/man1/logtime.1
		rm -f /usr/local/man/cat1/logtime.1* /usr/man/cat1/logtime.1*
		rm -f /var/catman/cat1/logtime.1* /var/catman/local/cat1/logtime.1*
	fi
	backupipfiles=1
fi

# Create the documentation directory if it does not exist
if test ! -d $docsdir ; then
		echo "Creating documentation directory: $docsdir"
fi
if test $docsdir = /usr/doc/logtime-1.21 ; then
	if test ! -d /usr/doc ; then
		if test $verbose != 0 ; then
			echo "mkdir /usr/doc"
			echo "chmod a+rx /usr/doc"
		fi
		if test $noaction = 0 ; then
			mkdir /usr/doc
			chmod a+rx /usr/doc
		fi
	fi
fi
if test ! -d $docsdir ; then
	if test $verbose != 0 ; then
		echo "mkdir $docsdir"
		echo "chmod a+rx $docsdir"
	fi
	if test $noaction = 0 ; then
		mkdir $docsdir
		chmod a+rx $docsdir
	fi
fi

# Now copy the new logtime and documentation from the current directory
echo "Copying logtime and documentation to destination directories"
if test $verbose != 0 ; then
	echo "$installprogram $installbinflags logtime.$extension $bindir/logtime"
	echo "$installprogram $installdataflags logtime.1 $mandir"
	echo "$installprogram $installdataflags $docfiles $docsdir"
fi
if test $noaction = 0 ; then
	if test -f README.Linux ; then
		linuxreadme=README.Linux
	else
		linuxreadme=readme.lin
	fi
	$installprogram $installbinflags logtime.$extension $bindir/logtime
	$installprogram $installdataflags logtime.1 $mandir
	$installprogram $installdataflags $docfiles $linuxreadme $docsdir
fi

# If the data directory is /var/local/lib/logtime, we need to create the
# directory structure for it in case it is missing. This is here for
# future use in case I decide to move the data directory to where it is
# supposed to be! We're still using $HOME/LOGTIME in the name of backward
# compatibility.
if test $datadir = /var/local/lib/logtime ; then
	echo "Creating /var/local/lib/logtime"
	if test ! -d /var ; then
		if test $verbose != 0 ; then
			echo "mkdir /var"
			echo "chmod a+rx /var"
		fi
		if test $noaction = 0 ; then
			mkdir /var
			chmod a+rx /var
		fi
	fi
	if test ! -d /var/local ; then
		if test $verbose != 0 ; then
			echo "mkdir /var/local"
			echo "chmod a+rx /var/local"
		fi
		if test $noaction = 0 ; then
			mkdir /var/local
			chmod a+rx /var/local
		fi
	fi
	if test ! -d /var/local/lib ; then
		if test $verbose != 0 ; then
			echo "mkdir /var/local/lib"
			echo "chmod a+rx /var/local/lib"
		fi
		if test $noaction = 0 ; then
			mkdir /var/local/lib
			chmod a+rx /var/local/lib
		fi
	fi
	if test ! -d /var/local/lib/logtime ; then
		if test $verbose != 0 ; then
			echo "mkdir /var/local/lib/logtime"
			echo "chmod a+rx /var/local/lib/logtime"
		fi
		if test $noaction = 0 ; then
			mkdir /var/local/lib/logtime
			chmod a+rx /var/local/lib/logtime
		fi
	fi
fi

# Now install /etc/ppp/ip-up and /etc/ppp/ip-down if requested.
if test $pppinstall != 0 ; then
	if test ! -d /etc/ppp ; then
		echo "Creating /etc/ppp directory"
		if test $verbose != 0 ; then
			echo "mkdir /etc/ppp"
		fi
		if test $noaction = 0 ; then
			mkdir /etc/ppp
		fi
	fi
	for ipfile in /etc/ppp/ip-up /etc/ppp/ip-down ; do
	    if test $ipfile = /etc/ppp/ip-up ; then
		echo "Modifying $ipfile to call \"logtime -b -D $datadir\""
	    else
		echo "Modifying $ipfile to call \"logtime -e -D $datadir\""
	    fi
	    if test -f $ipfile ; then
		if test $verbose != 0 ; then
			echo grep -v \""$suffixstr"\" $ipfile \> $tempname
		fi
		if test $noaction = 0 ; then
			grep -v "$suffixstr" $ipfile > $tempname
		fi
	    else
		if test $verbose != 0 ; then
			echo "echo \"#! /bin/sh\" > $tempname"
		fi
		if test $noaction = 0 ; then
			echo "#! /bin/sh" > $tempname
		fi
	    fi
	    # we have to add a newline before our addition of the logtime
	    # line just in case the user did not end the file with a newline
	    if test $verbose != 0 ; then
		echo "echo >> $tempname"
		if test $ipfile = /etc/ppp/ip-up ; then
		    echo "echo \"logtime -b -D $datadir $suffixstr\" >> $tempname"
		else
		    echo "echo \"logtime -e -D $datadir $suffixstr\" >> $tempname"
		fi
		echo "chmod +rx $tempname"
	    fi
	    if test $noaction = 0 ; then
		echo >> $tempname
		if test $ipfile = /etc/ppp/ip-up ; then
		    echo "logtime -b -D $datadir $suffixstr" >> $tempname
		else
		    echo "logtime -e -D $datadir $suffixstr" >> $tempname
		fi
		chmod +rx $tempname
	    fi
	    # save the original file with a .bak extension only if
	    # it exists and we ran uninstall.sh with a -p or we
	    # don't have an uninstall.sh to run.
	    # If we did not run uninstall.sh with a -p, this action
	    # will wind up wiping out the *real* original /etc/ip-xxxx
	    # script, and saving only the script that uninstall.sh created.
	    if test -f $ipfile && test $backupipfiles = 1 ; then
		if test $verbose != 0 ; then
			echo "mv $ipfile $ipfile.bak"
		fi
		if test $noaction = 0 ; then
			mv $ipfile $ipfile.bak
		fi
	    else
		# otherwise remove the original ip-up or ip-down file
		# if it exists
		if test $verbose != 0 ; then
			echo "rm -f $ipfile"
		fi
		if test $noaction = 0 ; then
			rm -f $ipfile
		fi
	    fi
	    if test $verbose != 0 ; then
		echo "mv $tempname $ipfile"
	    fi
	    if test $noaction = 0 ; then
		mv $tempname $ipfile
	    fi
	done
else
	echo "Skipping the modification of /etc/ppp/ip-up and /etc/ppp/ip-down"
fi

# create the uninstall script
if test ! -d $instcfgdir ; then
	echo "Creating $instcfgdir"
	if test $verbose != 0 ; then
		echo "mkdir $instcfgdir"
		echo "chmod a+rx $instcfgdir"
	fi
	if test $noaction = 0 ; then
		mkdir $instcfgdir
		chmod a+rx $instcfgdir
	fi
fi
echo "Creating the uninstall script in $instcfgdir"
if test $verbose != 0 ; then
	echo "echo \"#! /bin/sh\" > $uninstallname"
	echo "echo \"# uninstall.sh	Uninstall script created by install.sh\" >> $uninstallname"
	echo "echo '# Copyright (c) 1996 by Christopher S L Heng. All rights reserved.' >> $uninstallname"
	echo "echo \"pppinstall=$pppinstall\" >>$uninstallname"
	echo "echo \"bindir=$bindir\" >>$uninstallname"
	echo "echo \"mandir=$mandir\" >>$uninstallname"
	echo "echo \"datadir=$datadir\" >>$uninstallname"
	echo "echo \"docsdir=$docsdir\" >>$uninstallname"
	echo "echo \"docfiles=\"$docfiles\"\" >>$uninstallname"
	echo "echo \"suffixstr=\\\"$suffixstr\\\"\" >> $uninstallname"
	echo "echo >> $uninstallname"
	echo "cat uninst.pt2 | grep -v \"#! /bin/sh\" >> $uninstallname"
	echo "chmod a+rx $uninstallname"
fi
if test $noaction = 0 ; then
	echo "#! /bin/sh" > $uninstallname
	echo "# uninstall.sh	Uninstall script created by install.sh" >> $uninstallname
	echo '# Copyright (c) 1996 by Christopher S L Heng. All rights reserved.' >> $uninstallname
	echo "pppinstall=$pppinstall" >>$uninstallname
	echo "bindir=$bindir" >>$uninstallname
	echo "mandir=$mandir" >>$uninstallname
	echo "datadir=$datadir" >>$uninstallname
	echo "docsdir=$docsdir" >>$uninstallname
	echo "docfiles=\"$docfiles $linuxreadme\"" >>$uninstallname
	echo "suffixstr=\"$suffixstr\"" >> $uninstallname
	echo >> $uninstallname
	cat uninst.pt2 | grep -v "#! /bin/sh" >> $uninstallname
	chmod a+rx $uninstallname
fi

echo
echo "Installation complete. Please read README.Linux or readme.lin"
echo "for further instructions on how to set up your SLIP/PPP software"
echo "for use with logtime, as well as how to configure the program."
echo "To uninstall logtime, run $uninstallname."
echo "For more information on how to uninstall, see logtime.1 or run"
echo "\"$uninstallname -h\"."

exit 0
