/*
 * This file is part of ispcost.
 *
 * ispcost is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * ispcost is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with ispcost; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Copyright 1996 Torsten Martinsen
 *
 * $Id: utils.c,v 1.1 1996/11/22 10:31:47 torsten Exp $
 */

#include <stdio.h>
#include <stdlib.h>

#include "ispcost.h"

void *
xmalloc(size_t size)
{
    void * p;

    if ((p = malloc(size)) != NULL)
	return p;
    fprintf(stderr, "out of memory\n");
    exit(1);
}

void
alarmsound(void)
{
    FILE *fp, *fpo;
    char * buf;
    long len;
	
    if (global.alarmsound == NULL)
	return;
    
    if ((fp = fopen(global.alarmsound, "r")) == NULL) {
	fprintf(stderr, "error opening file '%s'\n", global.alarmsound);
	return;
    }
    if ((fpo = fopen(AUDIODEVICE, "w")) == NULL) {
	fprintf(stderr, "error opening '%s'\n", AUDIODEVICE);
	return;
    }
    fseek(fp, 0L, SEEK_END);
    len = ftell(fp);
    fseek(fp, 0L, SEEK_SET);
    buf = xmalloc(len);
    if (fread(buf, len, 1, fp) != 1) {
	fprintf(stderr, "error reading file '%s'\n",
		global.alarmsound);
	free(buf);
	return;
    }
    fwrite(buf, len, 1, fpo);
    fflush(fpo);
    free(buf);
}
