/*
 * This file is part of ispcost.
 *
 * ispcost is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * ispcost is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with ispcost; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Copyright 1996 Torsten Martinsen
 *
 * $Id: ispcost.h,v 1.19 1996/11/21 17:11:54 torsten Exp $
 */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <time.h>

/*
 * MODULES should be 1 if
 * - you have compiled kernel PPP support as a module,
 * and
 * - you do not run kerneld.
 * 'ispcost' will then load the modules 'slhc' and 'ppp'.
 * If you run kerneld, it will automatically load the modules.
 * Set BSD_COMP to 1 if you want to use compressed headers.
 * 'ispcost' will then load the module 'bsd_comp'.
 */
#define MODULES		0
#define BSD_COMP	1

/*
 * If you want ispcost to show detailed information while connecting, set
 * SHOW_CONNECT_STATUS to 1. For this to work optimally, make sure your chat
 * script includes the sequence
 *
 *	ABORT BUSY ABORT 'NO CARRIER' ABORT 'NO DIALTONE'
 *
 * as shown in 'sample-scripts/ppp-connect'. Also double-check the definition
 * of SYSLOGFILE below.
 * If you set SHOW_CONNECT_STATUS to 0, you need to install the 'ip-up' and
 * 'ip-down' scripts in /etc/ppp - otherwise ispcost can not tell whether the
 * link is up.
 */
#define SHOW_CONNECT_STATUS	1

/*
 * These should conform to the Linux FSSTND.
 */
#define PPPD		"/usr/sbin/pppd"	/* Path to PPP daemon */
#define PPPDFILE	"/etc/ppp/linkinfo"	/* Created by /etc/ppp/ip-up */
#define PPPDPIDFILE	"/var/run/ppp0.pid"	/* PID of PPP daemon */
#define CONNECTSCRIPT	"/etc/ppp/ispcost-ppp-connect"

/*
 * This is the file where pppd messages are logged.
 * If your /etc/syslog.conf has an entry something like
 *	local2.notice;local2.debug			/var/log/ppp.log
 * then SYSLOGFILE should be defined as "/var/log/ppp.log".
 * Otherwise, the default should work OK.
 */
#define SYSLOGFILE	"/var/log/messages"	/* Syslog messages */
#define INSMOD		"/sbin/insmod"		/* Path to insmod */
#define RMMOD		"/sbin/rmmod"		/* Path to rmmod */

#define AUDIODEVICE	"/dev/audio"

/*
 * It should not be necessary to change any of the following defines.
 */
#define BANNER		"ispcost " VERSION
#define NMONTHS		12	/* # of months shown in Totals window */

#define TICKINTERVAL 1000	/* How often to update clock (ms) */
#define COSTINTERVAL 5		/* How often to update cost (seconds) */

#define SYSRCFILE	"/etc/ispcostrc"
#define USERRCFILE	"~/.ispcostrc"
#define DEFAULTLOGFILE  "~/.ispcostlog"

#define ICONWIDTH	64
#define ICONHEIGHT	64

typedef void (*Voidfunc)(void);

/*
 * Globals
 */
extern int cstate;
extern int testing;
extern Pixel blackcol, greycol, iconfgcol, iconbgcol;
extern Widget myshell, statsshell, confshell;
extern Widget connectb, statsb, confb, text1, text2, text3, message;
extern XtAppContext mycontext;
extern Pixmap connectbitmap, disconnectbitmap, abortbitmap;
extern char * itemslabelname, * totalslabelname, *iconfontname;
extern Atom wm_delete_window;
extern int iconified;
extern Window iconwindow;

/*
 * Connection states
 */
#define CSTATE_NC	  0
#define CSTATE_CONNECTED  1
#define CSTATE_TRYING	  2
#define CSTATE_BUSY	  3

typedef struct
{
    int redialinterval;
    int connecttimeout;
    int redial;
    float dialcost;
    char * logfile;
    char * number;
    char * country;
    char * currency;
    char * alarmsound;
} GlobalOptions;

extern GlobalOptions global;

/*
 * Prototypes
 */

/* callbacks.c */
void connectcb(Widget w, void *junk1, void *junk2);
void quitcb(Widget w, void *junk1, void *junk2);
void statscb(Widget w, void * junk1, void *junk2);
void closestatscb(Widget w, XtPointer junk1, XtPointer junk2);
void confcb(Widget w, void * junk1, void * junk2);
void closeconfcb(Widget w, XtPointer junk1, XtPointer junk2);
void hangup_done(void);

/* connect.c */
void doconnect(void);
void hangup(Voidfunc func);

/* cost.c */
void clocktick(XtPointer junk, XtIntervalId * id);
void startclock(void);
void stopclock(void);
void log_costs(void);
void add_dial_cost(void);

/* display.c */
void update_display(int doclock, int docost, int dorate);
void set_display(char *clockstr, char *coststr, char *ratestr);
void repaint(Widget w, int new_width, int new_height, void *data);
void repaint1(Widget w, int new_width, int new_height, void *data);
void sa_printf(char * format, ...);

/* holidays.c */
int isholiday(struct tm * lt);

/* ispcost.c */
void wm_protocols(Widget w, XEvent * event, String * params,
		  Cardinal * num_params);

/* modules.c */
void load_module(char * name);
void unload_module(char * name);

/* readrc.c */
int parserc(char * rcfile);
char ** getNumberList(int * np);

/* stats.c */
char *** getStatistics(int * np, char *** totals);
void stat_free(void);

/* utils.c */
void * xmalloc(size_t size);
void alarmsound(void);
