/*
 * This file is part of ispcost.
 *
 * ispcost is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * ispcost is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with ispcost; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Copyright 1996 Torsten Martinsen
 *
 * $Id: readrc.h,v 1.4 1996/09/04 19:33:47 torsten Exp $
 */

typedef struct whennight {
    int s_hour;		/* When night rate begins */
    int s_min;
    int e_hour;		/* When night rate ends */
    int e_min;
    struct whennight * next;
} Whennight;


typedef struct prefixinfo {
    char * prefix;		/* First digits of phone number */
    float dialcost;
    float dayrate;
    float nightrate;
    Whennight * whennight;	/* When the night rate applies */
    int cheapdays[7];		/* Days, if any, where the night rate 
				   applies all day long */
    int cheapholidays;
    struct prefixinfo * next;
} PrefixInfo;

typedef void (*parsefunc)(char *, void *);

typedef struct {
    char * name;
    parsefunc func;
    void * data;
} Keywords;

PrefixInfo * getPrefixInfo(char * num);

extern PrefixInfo * curpreinfo;
