/*
 * This file is part of ispcost.
 *
 * ispcost is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * ispcost is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with ispcost; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Copyright 1996 Torsten Martinsen
 *
 * $Id: modules.c,v 1.2 1996/08/09 07:59:22 torsten Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include "ispcost.h"

#ifdef MODULES
void
load_module(char * name)
{
  char command[80];

  sprintf(command, INSMOD " %s >& /dev/null\n", name);
  system(command);
  if (errno)
    perror("system");
}

/*
 * Unload specified module using rmmod, ignoring any errors.
 */
void
unload_module(char * name)
{
  char command[80];

  sprintf(command, RMMOD " %s >& /dev/null\n", name);
  system(command);
}
#endif
