/*
 * This file is part of ispcost.
 *
 * ispcost is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * ispcost is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with ispcost; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Copyright 1996 Torsten Martinsen
 *
 * $Id: ispcost.c,v 1.21 1996/11/21 17:08:01 torsten Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <malloc.h>
#include <fcntl.h>

#include "ispcost.h"

#include <X11/xpm.h>

#include "icons/connecticon"
#include "icons/disconnecticon"
#include "icons/aborticon"
#include "icons/statsicon"

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>

#define DEFAULTCLASS "Ispcost"

Widget myshell, text1, text2, text3, message, connectb, statsb, confb;
int iconified = 0;

Atom wm_delete_window;
Window iconwindow;

XFontStruct * textfont, * msgfont;
Pixel blackcol, greycol, iconfgcol, iconbgcol;
XtAppContext mycontext;

#ifdef TEST
int testing;
#endif
char * itemslabelname, * totalslabelname, * iconfontname;
Pixmap connectbitmap, disconnectbitmap, abortbitmap;

static char * blackcolname, * greycolname, * iconfgcolname, * iconbgcolname;

typedef struct {
    char * name;
    char ** val;
    char * fallback;
} Res;

static Res res[] = {
    { "Ispcost.blackcol",	 &blackcolname,	       "black" },
    { "Ispcost.greycol",	 &greycolname,	       "grey"  },
    { "Ispcost.itemslabel",      &itemslabelname,      "items" },
    { "Ispcost.totalslabel",     &totalslabelname,     "totals" },
    { "Ispcost.iconfont",        &iconfontname,	       "fixed" },
    { "Ispcost.iconForeground",  &iconfgcolname,       "black" },
    { "Ispcost.iconBackground",  &iconbgcolname,       "white" },
    { NULL, NULL }
};

static Arg args[4];




static XtActionsRec actions[] =
{
    {"wm_protocols", wm_protocols},
};

static String translations = "<Message>WM_PROTOCOLS: wm_protocols()";


void 
main(int argc, char *argv[])
{
    XColor xcol;
    int e;
    Widget pane, commandbox, dispbox, textform, messageform;
    char *str;
    XrmValue val;
    Res * rp;
    Display * dpy;
    Screen * screen;
    Window win;
    XpmAttributes myattributes;
    Pixmap statsbitmap;
    
#ifdef TEST
    testing = argc > 1;
#endif

#if !defined(TEST)
    if (geteuid()) {
	fprintf(stderr, "%s: I must be installed setuid root.\n", argv[0]);
	exit(1);
    }
#endif
    
    /* Parse configuration files */
    e = parserc(SYSRCFILE);
    e += parserc(USERRCFILE);

    if (!e) {
	printf("Fatal error: No initialization file found\n");
	exit(1);
    }

    myshell = XtAppInitialize(&mycontext, DEFAULTCLASS, NULL, 0, &argc, argv,
			      NULL, NULL, 0);
    screen = XtScreen(myshell);
    
    /* Get resources */

    for (rp = res; rp->name != NULL; ++rp)
	if (XrmGetResource(XtDatabase(XtDisplay(myshell)), rp->name,
			   "Ispcost", &str, &val))
	    *(rp->val) = val.addr;
	else
	    *(rp->val) = rp->fallback;

    XAllocNamedColor(XtDisplay(myshell),
		     DefaultColormapOfScreen(screen),
		     blackcolname, &xcol, &xcol);
    blackcol = xcol.pixel;
    XAllocNamedColor(XtDisplay(myshell),
		     DefaultColormapOfScreen(screen),
		     greycolname, &xcol, &xcol);
    greycol = xcol.pixel;
    XAllocNamedColor(XtDisplay(myshell),
		     DefaultColormapOfScreen(screen),
		     iconbgcolname, &xcol, &xcol);
    iconbgcol = xcol.pixel;
    XAllocNamedColor(XtDisplay(myshell),
		     DefaultColormapOfScreen(screen),
		     iconfgcolname, &xcol, &xcol);
    iconfgcol = xcol.pixel;

    /* Handle WM_DELETE_WINDOW protocol */
    
    wm_delete_window = XInternAtom(XtDisplay(myshell),
				   "WM_DELETE_WINDOW", False);
    XtAppAddActions(mycontext, actions, XtNumber(actions));
    XtOverrideTranslations(myshell, XtParseTranslationTable(translations));

    /* Icon window */

    dpy = XtDisplay(myshell);
    iconwindow = XCreateSimpleWindow(dpy, RootWindowOfScreen(screen),
				     0, 0, ICONWIDTH, ICONHEIGHT, 0,
				     iconbgcol,
				     WhitePixelOfScreen(screen));

    XtVaSetValues(myshell, XtNiconWindow, iconwindow, NULL);

    /* Create widgets */
    
    pane = XtCreateManagedWidget("rootpane", panedWidgetClass, myshell, NULL, 0);

    XtSetArg(args[0], XtNresizeToPreferred, True);
    XtSetArg(args[1], XtNskipAdjust, True);
    XtSetArg(args[2], XtNshowGrip, False);

    commandbox = XtCreateManagedWidget("commandbox",
				       boxWidgetClass, pane, args, 3);

    dispbox = XtCreateManagedWidget("dispbox", boxWidgetClass, pane, args, 3);

    textform = XtVaCreateManagedWidget("textform", formWidgetClass, pane,
				       XtNshowGrip, False, NULL);

    text1 = XtVaCreateManagedWidget("ttxt",
				    labelWidgetClass, textform,
				    XtNborderWidth, 0,
				    XtNforeground, greycol, NULL);
    text2 = XtVaCreateManagedWidget("ctxt",
				    labelWidgetClass, textform,
				    XtNborderWidth, 0,
				    XtNforeground, greycol,
				    XtNfromVert, text1, NULL);
    text3 = XtVaCreateManagedWidget("rtxt",
				    labelWidgetClass, textform,
				    XtNborderWidth, 0,
				    XtNforeground, greycol,
				    XtNfromVert, text2, NULL);

    messageform = XtCreateManagedWidget("messageform",
					formWidgetClass, pane, args, 3);

    message = XtVaCreateManagedWidget("message",
				      labelWidgetClass, messageform,
				      XtNresize, 0,
				      NULL);

    myattributes.valuemask = XpmCloseness;
    myattributes.closeness = 65535;
    win = RootWindowOfScreen(screen);
    if (XpmCreatePixmapFromData(dpy, win, connecticon,
				&connectbitmap, NULL, &myattributes) ||
	XpmCreatePixmapFromData(dpy, win, disconnecticon,
				&disconnectbitmap, NULL, &myattributes) ||
	XpmCreatePixmapFromData(dpy, win, aborticon,
				&abortbitmap, NULL, &myattributes) ||
	XpmCreatePixmapFromData(dpy, win, statsicon,
				&statsbitmap, NULL, &myattributes)) {
	fprintf(stderr, "Cannot install icons\n");
	exit(1);
    }
    
    connectb = XtVaCreateManagedWidget("cbut",
				       commandWidgetClass, commandbox,
				       XtNresize, 0,
				       XtNbitmap, connectbitmap,
				       NULL);
    XtAddCallback(connectb, XtNcallback, connectcb, NULL);

    statsb = XtVaCreateManagedWidget("sbut",
				     commandWidgetClass, commandbox,
				     XtNbitmap, statsbitmap, NULL);
    XtAddCallback(statsb, XtNcallback, statscb, NULL);

    confb = XtVaCreateManagedWidget("cfbut",
				    commandWidgetClass, commandbox,
#if 0
				    XtNbitmap, confbitmap,
#endif
				    NULL);
    XtAddCallback(confb, XtNcallback, confcb, NULL);

    sa_printf("***********************************");
    XtVaSetValues(connectb, XtNbitmap, connectbitmap, NULL);
    
    XtRealizeWidget(myshell);

    XSetWMProtocols(XtDisplay(myshell), XtWindow(myshell), &wm_delete_window, 1);

    sa_printf(BANNER);
    XtAppAddTimeOut(mycontext, 0, clocktick, NULL);
    
#if MODULES
    load_module("slhc");
    load_module("ppp");
#if BSD_COMP
    load_module("bsd_comp");
#endif
#endif

    do {
	XEvent event;
	
	XtAppNextEvent(mycontext, &event);
	if ((event.type == MapNotify) || (event.type == UnmapNotify))
	    if (((XMapEvent *) &event)->window == XtWindow(myshell))
		if (event.type == UnmapNotify)
		    iconified = 1;
		else
		    iconified = 0;
	XtDispatchEvent(&event);
    }
    while (1);
}


void 
wm_protocols(Widget w, XEvent * event, String * params, Cardinal * num_params)
{
    if (event->type != ClientMessage)
	return;
    if (event->xclient.data.l[0] == wm_delete_window) {
	if (w == statsshell)
	    closestatscb(NULL, NULL, NULL);
	else if (w == confshell)
	    closeconfcb(NULL, NULL, NULL);
	else if (w == myshell)
	    quitcb(NULL, NULL, NULL);
    }
}
