/*
 * This file is part of ispcost.
 *
 * ispcost is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * ispcost is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with ispcost; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Copyright 1996 Torsten Martinsen
 *
 * $Id: display.c,v 1.12 1996/11/21 17:07:35 torsten Exp $
 */

#include <stdio.h>
#include <stdarg.h>
#include <time.h>

#include "ispcost.h"

#include "icons/animicon1"
#include "icons/animicon2"
#include "icons/animicon3"
#include "icons/animicon4"

static char * clockstring = NULL, * coststring = NULL, * ratestring = NULL;

void
set_display(char * clockstr, char * coststr, char * ratestr)
{
  clockstring = clockstr;
  coststring = coststr;
  ratestring = ratestr;
}

/*
 * Update the specified items.
 * If we are iconified, draw directly into the icon pixmap.
 * Otherwise, just set the label texts.
 */
void
update_display(int doclock, int docost, int dorate)
{
    Pixel col = blackcol;
    char str[20];


    if (!iconified) {
	if (cstate != CSTATE_CONNECTED)
	    col = greycol;
	
	if (doclock && clockstring)
	    XtVaSetValues(text1, XtNlabel, clockstring,
			  XtNforeground, col, NULL);
	if (docost && coststring) {
	    strcpy(str, global.currency);
	    strcat(str, " ");
	    strcat(str, coststring);
	    XtVaSetValues(text2, XtNlabel, str, XtNforeground, col, NULL);
	}
	if (dorate && ratestring) {
	    strcpy(str, ratestring);
	    strcat(str, "/min");
	    XtVaSetValues(text3, XtNlabel, str, XtNforeground, col, NULL);
	}
    } else {
	static GC gc;
	XGCValues values;
	Display * dpy = XtDisplay(myshell);
	static XFontStruct * fontstruct = NULL;
	int i, dir, asc, desc;
	XCharStruct xcs;
	static anistate = 0;
	static Pixmap anipixmap[4];
	static unsigned char * anibits[] = {
	    animicon1_bits,
	    animicon2_bits,
	    animicon3_bits,
	    animicon4_bits
	};
	
	if (fontstruct == NULL) {
	    fontstruct = XLoadQueryFont(dpy, iconfontname);
	    
	    values.font = fontstruct->fid;
	    values.background = iconbgcol;
	    values.foreground = iconfgcol;
	    gc = XCreateGC(dpy, iconwindow,
			   GCFont | GCForeground | GCBackground, &values);
	    
	    for (i = 0; i < 4; ++i)
		anipixmap[i] = XCreateBitmapFromData(XtDisplay(myshell),
						     XtScreen(myshell)->root,
						     (char *) anibits[i],
						     animicon1_width,
						     animicon1_height);
	}
	
	XSetForeground(dpy, gc, iconbgcol);
	XFillRectangle(dpy, iconwindow, gc, 0, 0, ICONWIDTH, ICONHEIGHT);
	XSetForeground(dpy, gc, iconfgcol);

	XTextExtents(fontstruct, coststring, strlen(coststring),
		     &dir, &asc, &desc, &xcs);
	XDrawImageString(dpy, iconwindow, gc,
			 (ICONWIDTH-xcs.width)/2,
			 ICONHEIGHT/2+desc,
			 coststring, strlen(coststring));

    	XTextExtents(fontstruct, clockstring, strlen(clockstring),
		     &dir, &asc, &desc, &xcs);
	XDrawImageString(dpy, iconwindow, gc,
			 (ICONWIDTH-xcs.width)/2,
			 ICONHEIGHT-desc-2,
			 clockstring, strlen(clockstring));

	if (cstate == CSTATE_CONNECTED) {
	    XCopyPlane(dpy, anipixmap[anistate], iconwindow, gc,
		       0, 0, animicon1_width, animicon1_height, 0, 4, 1);
	    if (++anistate >= 4)
		anistate = 0;
	}
    }      
}

static char statusmsg[80] = "";		/* Current contents of status area */

/*
 * Print a string in the status area and save it so that
 * future repaints will redisplay it.
 */
void
sa_printf(char * format, ...)
{
  va_list args;

  va_start(args, format);
  vsprintf(statusmsg, format, args);
  va_end(args);

  XtVaSetValues(message, XtNlabel, statusmsg, NULL);
}
