/*
 * This file is part of ispcost.
 *
 * ispcost is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * ispcost is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with ispcost; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Copyright 1996 Torsten Martinsen
 *
 * $Id: configure.c,v 1.4 1996/11/21 17:08:47 torsten Exp $
 */

#include <stdio.h>

#include "ispcost.h"
#include "readrc.h"
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>

Widget confshell = NULL;

static String translations = "<Message>WM_PROTOCOLS: wm_protocols()";
static GlobalOptions *oldvals;
static Widget numbermenub;

static void numbercb(Widget w, XtPointer data, XtPointer call_data);
static void confokcb(Widget w, XtPointer junk1, XtPointer junk2);
static void confcancelcb(Widget w, XtPointer junk1, XtPointer junk2);


/*
 * Popup the configure dialog.
 */
void
confcb(Widget w, void * junk1, void * junk2)
{
    Widget confok, confcancel, confbuttonbox, confpane;
    Widget menu, sme, label;
    char ** items;
    int i, n;
  
    XtVaSetValues(confb, XtNsensitive, False, NULL);

    if (global.number == NULL) {
	global.number = *getNumberList(NULL);
	curpreinfo = getPrefixInfo(global.number);
    }

    oldvals = (GlobalOptions *) XtMalloc(sizeof(GlobalOptions));
    memcpy(oldvals, &global, sizeof(GlobalOptions));

    if (confshell) {
	XtPopup(confshell, XtGrabNone);
	return;
    }

    confshell = XtVaCreatePopupShell("confshell", topLevelShellWidgetClass,
				     confb, XtNwindowGroup, &myshell, NULL);
    XtOverrideTranslations(confshell, XtParseTranslationTable(translations));

    confpane = XtVaCreateManagedWidget("rootpane", panedWidgetClass,
				       confshell, NULL);
    confbuttonbox = XtVaCreateManagedWidget("box1", boxWidgetClass,
					    confpane,
					    XtNresizeToPreferred, True,
					    XtNskipAdjust, True,
					    XtNshowGrip, False, NULL);

    label = XtVaCreateManagedWidget("nlab",
				    labelWidgetClass, confbuttonbox,
				    XtNborderWidth, 0,
				    NULL);
    numbermenub = XtVaCreateManagedWidget("nmenu",
					  menuButtonWidgetClass, confbuttonbox,
					  XtNlabel, global.number, NULL);

    menu = XtVaCreatePopupShell("menu",
				simpleMenuWidgetClass, numbermenub, NULL);

    items = getNumberList(&n);
    for(i = 0; i < n; i++) {
	sme = XtVaCreateManagedWidget(*items,
				      smeBSBObjectClass,
				      menu, NULL); 
	XtAddCallback(sme, XtNcallback, numbercb, *items);
	++items;
    }

    confbuttonbox = XtVaCreateManagedWidget("box2", boxWidgetClass,
					    confpane,
					    XtNresizeToPreferred, True,
					    XtNskipAdjust, True, NULL);

    confok = XtVaCreateManagedWidget("ok", commandWidgetClass,
					confbuttonbox, NULL);
    XtAddCallback(confok, XtNcallback, confokcb, NULL);
    confcancel = XtVaCreateManagedWidget("cancel", commandWidgetClass,
					confbuttonbox, NULL);
    XtAddCallback(confcancel, XtNcallback, confcancelcb, NULL);

    XtPopup(confshell, XtGrabNone);
    XSetWMProtocols(XtDisplay(confshell), XtWindow(confshell),
		    &wm_delete_window, 1);
}

static void
numbercb(Widget w, XtPointer data, XtPointer call_data)
{
    global.number = data;
    XtVaSetValues(numbermenub, XtNlabel, data, NULL);
    curpreinfo = getPrefixInfo(global.number);
}


static void
confokcb(Widget w, XtPointer junk1, XtPointer junk2)
{
    XtFree((XtPointer) oldvals);
    closeconfcb(w, junk1, junk2);
}

static void
confcancelcb(Widget w, XtPointer junk1, XtPointer junk2)
{
    memcpy(&global, oldvals, sizeof(GlobalOptions));
    XtFree((XtPointer) oldvals);
    closeconfcb(w, junk1, junk2);
}

void
closeconfcb(Widget w, XtPointer junk1, XtPointer junk2)
{
    XtVaSetValues(confb, XtNsensitive, True, NULL);
    if (confshell)
	XtPopdown(confshell);
}
