/*
 * This file is part of ispcost.
 *
 * ispcost is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * ispcost is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with ispcost; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Copyright 1996 Torsten Martinsen
 *
 * $Id: callbacks.c,v 1.12 1996/11/21 17:08:34 torsten Exp $
 */

#include <stdio.h>

#include "ispcost.h"
#include "readrc.h"
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>

int cstate = CSTATE_NC;
Widget statsshell = NULL;

typedef enum { TOTALS, ITEMS } State;
static State state = TOTALS;

static String translations = "<Message>WM_PROTOCOLS: wm_protocols()";

static void listcb(Widget w, XtPointer data, XtPointer call_data);

void
connectcb(Widget w, void * junk1, void * junk2)
{
    switch (cstate) {
    case CSTATE_NC:
	if (global.number == NULL) {
	    global.number = *getNumberList(NULL);
	    curpreinfo = getPrefixInfo(global.number);
	}
	XtVaSetValues(connectb, XtNsensitive, 0, NULL);
	doconnect();
	break;
    case CSTATE_CONNECTED:
    case CSTATE_TRYING:
    case CSTATE_BUSY:
	XtVaSetValues(connectb, XtNsensitive, 0, NULL);
	stopclock();
	hangup(hangup_done);
	cstate = CSTATE_NC;
	update_display(1, 1, 1);
	sa_printf("Not connected");
	break;
    }
}

void
quitcb(Widget w, void * junk1, void * junk2)
{
    if (cstate != CSTATE_NC) {
	stopclock();
	hangup(hangup_done);
    }
#if MODULES
#if BSD_COMP
    unload_module("bsd_comp");
#endif
    unload_module("ppp");
    unload_module("slhc");
#endif
    XtDestroyApplicationContext(mycontext);
    exit(0);
}

static char *** items, ** totals;
static Widget stats_label, listwidget;


/*
 * Show statistics on recorded calls.
 */
void
statscb(Widget w, void * junk1, void * junk2)
{
    Widget stats_close, stats_pane, stats_form, stats_buttonbox, vport;
    int n;
  
    if ((items = getStatistics(&n, &totals)) == NULL)
	return;

    XtVaSetValues(statsb, XtNsensitive, False, NULL);

    if (statsshell) {
	XawListChange(listwidget, totals, -1, -1, TRUE);
	state = TOTALS;
	XtVaSetValues(statsshell, XtNwidth, 290, NULL);
	XtVaSetValues(stats_label, XtNlabel, totalslabelname, NULL);
	XtPopup(statsshell, XtGrabNone);
	return;
    }

    statsshell = XtVaCreatePopupShell("statsshell", topLevelShellWidgetClass,
				      statsb, XtNwindowGroup, &myshell, NULL);
    XtOverrideTranslations(statsshell, XtParseTranslationTable(translations));

    stats_pane = XtVaCreateManagedWidget("rootpane", panedWidgetClass,
					 statsshell, NULL);

    stats_label = XtVaCreateManagedWidget("slab",
					  labelWidgetClass, stats_pane,
					  XtNlabel, totalslabelname,
					  XtNborderWidth, 0,
					  XtNshowGrip, False,
					  NULL);

    stats_form = XtVaCreateManagedWidget("textform", formWidgetClass, stats_pane,
					 XtNshowGrip, False, NULL);

    stats_buttonbox = XtVaCreateManagedWidget("buttonbox", boxWidgetClass,
					      stats_pane,
					      XtNresizeToPreferred, True,
					      XtNskipAdjust, True, NULL);

    stats_close = XtVaCreateManagedWidget("close", commandWidgetClass,
					  stats_buttonbox, NULL);
    XtAddCallback(stats_close, XtNcallback, closestatscb, NULL);

    vport = XtVaCreateManagedWidget("vport", viewportWidgetClass,
				    stats_form,
				    XtNallowVert, True,
				    XtNallowHoriz, True,
				    XtNuseBottom, True, NULL);
  
    listwidget = XtVaCreateManagedWidget("list", listWidgetClass,
					 vport,
					 XtNlist, totals,
					 XtNverticalList, True,
					 XtNforceColumns, True,
					 XtNdefaultColumns, 1,
					 XtNborderWidth, 1, NULL);
    
    XtAddCallback(listwidget, XtNcallback, listcb, NULL);
  
    XtPopup(statsshell, XtGrabNone);
    XSetWMProtocols(XtDisplay(statsshell), XtWindow(statsshell),
		    &wm_delete_window, 1);
}

static void
listcb(Widget w, XtPointer data, XtPointer call_data)
{
    XawListReturnStruct *list = (XawListReturnStruct *) call_data;

    if (state == TOTALS) {
	if ((list->list_index < NMONTHS) && (items[list->list_index]) != NULL) {
	    XawListChange(listwidget, items[list->list_index], -1, -1, TRUE);
	    state = ITEMS;
	    XtVaSetValues(statsshell, XtNwidth, 570, NULL);
	    XtVaSetValues(stats_label, XtNlabel, itemslabelname, NULL);
	}
    } else {
	XawListChange(listwidget, totals, -1, -1, TRUE);
	state = TOTALS;
	XtVaSetValues(statsshell, XtNwidth, 290, NULL);
	XtVaSetValues(stats_label, XtNlabel, totalslabelname, NULL);
    }
}

/*
 * Close the Statistics dialog.
 */
void
closestatscb(Widget w, XtPointer junk1, XtPointer junk2)
{
    XtVaSetValues(statsb, XtNsensitive, True, NULL);
    if (statsshell)
	XtPopdown(statsshell);
    stat_free();
}

void
hangup_done(void)
{
  XtVaSetValues(connectb, XtNbitmap, connectbitmap, XtNsensitive, 1, NULL);
}
