#ifndef __DIALTTY_H
#define __DIALTTY_H


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/ioctl.h>
#include <termio.h>
#include <signal.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>
#include <utmp.h>
#include <getopt.h>
#include <memory.h>
#include <sys/file.h>
#include <sys/param.h>
#include <sys/utsname.h>
#include <syslog.h>
#include <setjmp.h>
#include <time.h>


typedef unsigned char  bool;


/* Some shorthands for control characters. */

#define CTL(x)		(x ^ 0100)	/* Assumes ASCII dialect */
#define	CR		CTL('M')	/* carriage return */
#define	NL		CTL('J')	/* line feed */
#define	BS		CTL('H')	/* back space */
#define	DEL		CTL('?')	/* delete */


/* Defaults for line-editing etc. characters; you may want to change this. */

#define DEF_ERASE	DEL		/* default erase character */
#define DEF_INTR	CTL('C')	/* default interrupt character */
#define DEF_QUIT	CTL('\\')	/* default quit char */
#define DEF_KILL	CTL('U')	/* default kill char */
#define DEF_EOF		CTL('D')	/* default EOF char */
#define DEF_EOL		0
#define DEF_SWITCH	0		/* default switch char */


#undef	TCGETA
#undef	TCSETA
#undef	TCSETAW
#define	TCGETA	TCGETS
#define	TCSETA	TCSETS
#define	TCSETAW	TCSETSW


/* Storage for things detected while the login name was read. */
struct chardata 
{
  int  erase;	  /* erase character */
  int  kill;	  /* kill character */
  int  eol;	  /* end-of-line character */
  int  parity;	  /* what parity did we see */
  int  capslock;  /* upper case without lower case */
};


static void  parse_args(int argc, char **argv);
static void  update_utmp(void);
static void  open_tty(void);
static void  termio_init(void);
static void  do_prompt(void);
static char *get_logname(struct chardata *cp);
static void  termio_final(struct chardata *cp);
static int   caps_lock(char *s);
static void  debug(unsigned char, unsigned int, char *fmt, ...);
static bool  send(char *s);
static bool  expect(char *s, unsigned int, char *send);
static void  ringer(void);
static void  login_alarm();
static void  term_signal();
static void  usr1_signal();
static unsigned int   extract_linespeed(void);
static void  hangup(void);


struct options
{
  char*          login;
  char*          tty;
  char*          initstring;
  char*          issue;
  unsigned char  rings;
  unsigned int   debug;
  bool           softconnect;
};


#define  D_WELCOME    0x0001  /* welcome messages */
#define  D_CMDLINE    0x0002  /* command line errors */
#define  D_MODEMINIT  0x0004  /* modem intialization messages */
#define  D_MODEMRSLT  0x0008  /* modem result messages */
#define  D_LINEOPEN   0x0010  /* modem line initialization errors */
#define  D_LOGIN      0x0020  /* login errors */
#define  D_SIGNAL     0x0040  /* signal messages */
#define  D_CONNECT    0x0080  /* connection errors */
#define  D_GENERAL    0x0100  /* general info (what am i going to do) */

#endif  /* __DIALTTY_H */
