# The m4 pre-processing and other modifications to the diald
# distribution's "standard.filter" file are distributed under the GNU
# copyright (c) 1997 The Meme Factory, Inc.  http://www.meme.com

# This is a pretty complicated set of filter rules.
# (These are the rules I use myself.)
#
# I've divided the rules up into four sections.
# TCP packets, UDP packets, ICMP packets and a general catch all rule
# at the end.

#------------------------------------------------------------------------------
# Rules for TCP packets.
#------------------------------------------------------------------------------
# General comments on the rule set:
#
# In general we would like to treat only data on a TCP link as signficant
# for timeouts. Therefore, we try to ignore packets with no data.
# Since the shortest possible set of headers in a TCP/IP packet is 40 bytes.
# Any packet with length 40 must have no data riding in it.
# We may miss some empty packets this way (optional routing information
# and other extras may be present in the IP header), but we should get
# most of them. Note that we don't want to filter out packets with
# tcp.live clear, since we use them later to speedup disconnects
# on some TCP links.
#
# We also want to make sure WWW packets live even if the TCP socket
# is shut down. We do this because WWW doesn't keep connections open
# once the data has been transfered, and it would be annoying to have the link
# keep bouncing up and down every time you get a document.
#
# Outside of WWW the most common use of TCP is for long lived connections,
# that once they are gone mean we no longer need the network connection.
# We don't neccessarily want to wait 10 minutes for the connection
# to go down when we don't have any telnet's or rlogin's running,
# so we want to speed up the timeout on TCP connections that have
# shutdown. We do this by catching packets that do not have the live flag set.
# This is controlled by QUICK_DROP.

# --- start of rule set proper ---

#
# Site specific customization and m4 macro processing.
#
sinclude(`/etc/diald/diald.conf.m4')dnl

#
# Standard m4 processing.
#

ifdef(`STARTUP_TIMEOUT', `dnl
# When initiating a connection we only give the link 15 seconds initially.
# The idea here is to deal with possibility that the network on the opposite
# end of the connection is unreachable. In this case you don"t really
# want to give the link 10 minutes up time. With the rule below
# we only give the link 15 seconds initially. If the network is reachable
# then we will normally get a response that actually contains some
# data within 15 seconds. If this causes problems because you have a slow
# response time at some site you want to regularly access, you can either
# increase the timeout or remove this rule.
accept tcp STARTUP_TIMEOUT tcp.syn
')dnl


ifdef(`IGNORE_NAMESERVER',`dnl
# Keep named xfers from holding the link up
ignore tcp tcp.dest=tcp.domain
ignore tcp tcp.source=tcp.domain
')dnl

ifdef(`SUPPORT_SCO_TELNET',`dnl
# (Ack! SCO telnet starts by sending empty SYNs and only opens the
# connection if it gets a response. Sheesh..)
accept tcp 5 ip.tot_len=40,tcp.syn
')dnl

ifdef(`STANDARD_IGNORES',`dnl
# keep empty packets from holding the link up (other than empty SYN packets)
ignore tcp ip.tot_len=40,tcp.live
')dnl

ifdef(`HTTP_TIMEOUT',`dnl
# make sure http transfers hold the link for 2 minutes, even after they end.
# NOTE: Your /etc/services may not define the tcp service http, in which
# case you should comment out the following two lines or get a more
# up to date /etc/services file. See the FAQ for information on obtaining
# a new /etc/services file.
accept tcp HTTP_TIMEOUT tcp.dest=tcp.http
accept tcp HTTP_TIMEOUT tcp.source=tcp.http
')dnl

ifdef(`QUICK_DROP',`dnl
# Once the link is no longer live, we try to shut down the connection
# quickly. Note that if the link is already down, a state change
# will not bring it back up.
keepup tcp 5 !tcp.live
ignore tcp !tcp.live
')dnl

ifdef(`FTP_TIMEOUT',`dnl
# an ftp-data or ftp connection can be expected to show reasonably frequent
# traffic.
accept tcp FTP_TIMEOUT tcp.dest=tcp.ftp
accept tcp FTP_TIMEOUT tcp.source=tcp.ftp

#NOTE: ftp-data is not defined in /etc/services files provided with
# setup prior to setup-1.7.
# If you want to define it add the following line to your /etc/services:
# ftp-data        20/tcp
accept tcp FTP_TIMEOUT tcp.dest=tcp.ftp-data
accept tcp FTP_TIMEOUT tcp.source=tcp.ftp-data
')dnl

ifdef(`NNTP_TIMEOUT',`dnl
# nntp is sort of like ftp, so we"ll treat it that way.
accept tcp NNTP_TIMEOUT tcp.dest=tcp.nntp
accept tcp NNTP_TIMEOUT tcp.source=tcp.nntp
')dnl

ifdef(`SEND_MAIL_TIMEOUT',`dnl
accept tcp SEND_MAIL_TIMEOUT tcp.dest=tcp.smtp
accept tcp SEND_MAIL_TIMEOUT tcp.source=tcp.smtp
')dnl

ifdef(`FETCH_MAIL_TIMEOUT',`dnl
# Mail is probably constantly checked for, we don"t want it
# bringing the link up and down.
accept tcp FETCH_MAIL_TIMEOUT tcp.dest=tcp.pop-3
accept tcp FETCH_MAIL_TIMEOUT tcp.source=tcp.pop-3

accept tcp FETCH_MAIL_TIMEOUT tcp.dest=tcp.pop-2
accept tcp FETCH_MAIL_TIMEOUT tcp.source=tcp.pop-2

accept tcp FETCH_MAIL_TIMEOUT tcp.dest=tcp.imap
')dnl

# Rules for UDP packets

ifdef(`STANDARD_IGNORES',`dnl
# Don"t bring the link up for rwho.
ignore udp udp.dest=udp.who
ignore udp udp.source=udp.who
# Don"t bring the link up for RIP.
ignore udp udp.dest=udp.route
ignore udp udp.source=udp.route
# Don"t bring the link up for NTP or timed.
ignore udp udp.dest=udp.ntp
ignore udp udp.source=udp.ntp
ignore udp udp.dest=udp.timed
ignore udp udp.source=udp.timed
')dnl
ifdef(`IGNORE_NAMESERVER',`dnl
# Don"t bring up on domain name requests between two running nameds.
# If you"re running a nameserver, this will usually prevent the link from
# ever coming up!
ignore udp udp.dest=udp.domain,udp.source=udp.domain
')dnl
ifdef(`DOMAIN_TIMEOUT',`dnl
# Bring up the network whenever we make a domain request from someplace
# other than named.

# We time out domain requests right away, we just want them to bring
# the link up, not keep it around for very long.
# This is because the network will usually come up on a call
# from the resolver library (unless you have all your commonly
# used addresses in /etc/hosts, in which case you will discover
# other problems.)
# Note that you should not make the timeout shorter than the time you
# might expect your DNS server to take to respond. Otherwise
# when the initial link gets established there might be a delay
# greater than this between the initial series of packets before
# any packets that keep the link up longer pass over the link.
accept udp DOMAIN_TIMEOUT udp.dest=udp.domain 
accept udp DOMAIN_TIMEOUT udp.source=udp.domain
')dnl
ifdef(`NETBIOS_NS_TIMEOUT',`dnl
# Do the same for netbios-ns broadcasts
# NOTE: your /etc/services file may not define the netbios-ns service
# in which case you should comment out the next three lines.

ifdef(`STANDARD_IGNORES',`dnl
ignore udp udp.source=udp.netbios-ns,udp.dest=udp.netbios-ns
')dnl
accept udp NETBIOS_NS_TIMEOUT udp.dest=udp.netbios-ns
accept udp NETBIOS_NS_TIMEOUT udp.source=udp.netbios-ns
')dnl
ifdef(`STANDARD_IGNORES',`dnl
# keep routed and gated transfers from holding the link up
ignore udp tcp.dest=udp.route
ignore udp tcp.source=udp.route
')dnl

#
# Custom user interface specific m4 macro processing.
#
sinclude(`/etc/diald/diald-'IFACE`.conf.m4')dnl

#
# Any custom user interface specific straight-up diald configuration 
# comes next to last.
#
include /etc/diald/diald-`'IFACE`'.conf

ifdef(`OTHER_TCP_TIMEOUT',`dnl
# If we don"t catch it above, give the link OTHER_TCP_TIMEOUT seconds up time.
accept tcp OTHER_TCP_TIMEOUT any
')dnl
ifdef(`OTHER_UDP_TIMEOUT',`dnl
# Anything else gets OTHER_UDP_TIMEOUT seconds.
accept udp OTHER_UDP_TIMEOUT any
')dnl
ifdef(`DEFAULT_TIMEOUT',`dnl
# Catch any packets that we didn"t catch above and give the connection
# DEFAULT_TIMEOUT seconds of live time.
accept any DEFAULT_TIMEOUT any
')dnl
