/* Copyright 2001  Mark Pulford <mark@kyne.com.au>
 * This file is subject to the terms and conditions of the GNU General Public
 * License. Read the file COPYING found in this archive for details, or
 * visit http://www.gnu.org/copyleft/gpl.html
 */

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include <gdbm.h>

const char *gdbm_error_str()
{
	switch(gdbm_errno) {
	case GDBM_MALLOC_ERROR:
	case GDBM_FILE_OPEN_ERROR:
	case GDBM_FILE_WRITE_ERROR:
	case GDBM_FILE_SEEK_ERROR:
	case GDBM_FILE_READ_ERROR:
		return strerror(errno);
	default:
		return gdbm_strerror(gdbm_errno);
	}
}

/* fmt passed to die() should be a string constant */
void die(const char *fmt, ...)
{
	va_list args;

	fprintf(stderr, "error: ");
	va_start(args, fmt);
	vfprintf(stderr, fmt, args);
	va_end(args);
	fprintf(stderr, "\n");
	exit(-1);
}
