Name: satellite
Summary: A client/daemon for tracking many machines with dynamic IP addresses
Version: 1.0.2
Release: 1
Source: http://www.kyne.com.au/~mark/%{name}-%{version}.tar.gz
Url: http://www.kyne.com.au/~mark/
Group: Networking/Utilities
Copyright: GPL
Packager: Mark Pulford <mark@kyne.com.au>
BuildRoot: /tmp/%{name}-root

%description
Satellite can track many remote machines with dynamic IP addresses in
situations where public DNS services are inappropriate. It can log
and alert an admin immediately when a site moves around, comes online,
or needs attention.

%prep
%setup

%build
./configure --prefix=/usr --localstatedir=/var/log
make

%install
make install DESTDIR=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%pre
if [ ! "`grep ^satellite /etc/passwd`" ]
then
	/usr/sbin/useradd -r -d / -s /dev/null satellite >/dev/null 2>&1
	echo Added user satellite
fi

%post
if [ ! -f /usr/etc/satellite.db ]
then
	/usr/sbin/satcfg -L
	chown satellite. /usr/etc/satellite.db
	chmod 600 /usr/etc/satellite.db
	echo Created /usr/etc/satellite.db configuration file
fi
if [ ! "`grep ^satellite /etc/services`" ]
then
	echo "satellite       1764/tcp" >> /etc/services
	echo satellite added to /etc/services
fi
if [ ! "`grep '^[^ \t]*satellite' /etc/inetd.conf`" ]
then
	echo Run satellited from inetd with a line in /etc/inetd.conf like:
	echo satellite stream tcp nowait satellite /usr/sbin/satellited satellited -v
fi
if [ ! -f /var/log/satellite ]
then
	touch /var/log/satellite
	chown satellite. /var/log/satellite
	echo Created /var/log/satellite
fi

%postun
echo You may want to remove satellite from /etc/inetd.conf now.

%files
%doc AUTHORS COPYING NEWS README THANKS scripts/satalert.sh
%doc /usr/man/man?/*
/usr/sbin/*
