#!/usr/bin/perl
#
# This cgi-script written for the Apache httpserver can be used to display
# html files made by the wiplc program. The script is able to
# make the color of the line indicating a specific IP address blue. As
# default the line of the retriviewing machine is colord blue.
#
# The htmldir variabel should be set to the directory where the html
# files made by wiplc can be found:

$htmldir="/var/www/wipl";

# The validfiles variable should be a list of the files it should be
# possible to retriview. This should be without the html extension:

@validfiles=("out","in");

# From the browser this script should now be called with something like:
#
#   redtable.cgi?type=in
#
# to display in.html coloring the line for the retriviewing machine blue.
# To make a blue line for another machine something like:
#
#  redtable.cgi?type=speed&ip=192.168.2.4
#
# NOTE: The IP adress must be showed in the HTML files for this script to work.
#
#-------------------------------------------------------------------------------

#---------------Find the file to show:
$ENV{QUERY_STRING}=~/.*type=(\w*)/;
$type=$1;

$file=$htmldir."/".$validfiles[0]; # Default
foreach $l (@validfiles) {
  if($type eq $l) { 
    $file=$htmldir."/".$l;
  }
}

#---------------Find the IP address to color:
if($ENV{QUERY_STRING}=~/.*ip=(\d*\.\d*\.\d*\.\d*)/) {
  $ipaddr=$1;
} else {
  $ENV{REMOTE_ADDR}=~/(\d*\.\d*\.\d*\.\d*)/;
  $ipaddr=$1;
}

#-------------And show the page

# Print head to http server:
print "Content-type: text/html\n\n";

# Open the file to start
open(FILE,$file.".html");

$ipstart=-1; # Where does the IP column start?

# And copy file to stdout with possible change
while($line=<FILE>) {
  if($ipstart==-1) {
    $ipstart=index($line,"IP");
  } else {
    if(substr($line,$ipstart)=~/\s*(\S*)/) {
      # $1 is now the IP address of this line - check with $ipaddr.
      # This is a bit troublesome because $1 is only the end of an
      # IP address while $ipaddr is a full address
      
      $i=length($ipaddr)-length($1);
      if($i>=0 && (substr($ipaddr,$i) eq $1) &&
        ($i==0 || (substr($ipaddr,$i-1,1) eq "."))) {
	# The IP adress of this line is the right one - display it red:
        print "<u><font color=#0000ff>$line</font></u>";
        next;
      }
    }      
  }
  print "$line";
}