// This module defines a class used to help executing the program via the
// ParseProgram class. It is used both by wipld and by wiplcExec.
 
class ScriptExec:ParseProgram {
  // The shared memory area:
  ServerMem* ca;
  
  // The time of the packet we are updateing:
  int64 packettime;

  int ct;  // If true program contains a variabel reference that requires
           // localtime to be called for each execution.
  tm time;
  
  // Cache of recently used cards and their location in ca.
  int last_used;
  int cache0_idx;
  card_id cache0_addr;
  int cache1_idx;
  card_id cache1_addr;
  
  // Gets the the index of the given card.
  // If insert is true it will be insered if it does not exists.
  // Returns:
  //   >=0: The index of the card
  //    -1: Card did not exists and insert was false
  //    -2: Error - then the error parameter is set
  int GetIdIdx(card_id&, int insert, char*& error);

  // Functions from ParseProgram:
  virtual int      TBLcardcnt()  { return ca->curcardc; }
  virtual int      TBLcntcnt()   { return ca->Counterc; }
  virtual int      TBLgetidx(card_id m, char*& error) { int i=getIdIdx(m,1,error); return i<0 ? 0 : i; }
  virtual mac_addr TBLgetmacaddr(int idx, char*& error);
  virtual ip_addr  TBLgetipaddr(int idx, char*& error);
  virtual void     TBLidxdel(int idx, char*& error);
  virtual int64*   TBLgetcnt(card_id, int counter, char*& error);
  virtual void print(const char* string) { printf("%s",string); }  
  
  protected:  

  // Get the position in the table for a given card
  int getIdIdx(card_id& m, int insert, char*&error) {
    if(cache0_idx!=-1 && !memcmp(&cache0_addr,&m,sizeof(m))) { last_used=0; return cache0_idx; }
    else if(cache1_idx!=-1 && !memcmp(&cache0_addr,&m,sizeof(m))) { last_used=1; return cache1_idx; }
    int i=GetIdIdx(m,insert,error);    
    if(last_used) { last_used=0; cache0_idx=i; cache0_addr=m; }
    else          { last_used=1; cache1_idx=i; cache1_addr=m; }
    return i;
  }
      
  public:
  ScriptExec() { ct=0; }

  // Compiles the program and returns an error (is from base class)
  ParseProgram::setProgram;
  
  // Also from base class
  ParseProgram::assert_cit;

  // This is called by setProgram. Can be used by the user to insert own
  // variabels:
  virtual types getSymbol(char* name, void*& location);
      
  // Consumes a packet returns 0 on succes and error message on fatal error.
  // The parameter should be the shared memory area:
  char* Consume(ServerMem* Ca, int64 PacketTime);  
};
