// This module is used by the daemon to read the configuration file.
// Why have noone written a standard class for reading configuratin files?

// A string that can be appended to and which expands dynamically:
class DynString {
  char* buf;
  int buflen;
  int bufallocsize;
  
  public:
  DynString()       { buf=new char[bufallocsize=80]; buflen=0; }
  ~DynString()      { delete[] buf; }
  void setEmpty()   { buflen=0; }
  char* getString() { return buf; }
  void add(char);
  void add(char*);
};

inline void DynString::add(char c) {
  if(buflen==bufallocsize) { // Allocate new buffer
    bufallocsize*=2;
    char* newbuf=new char[bufallocsize];
    memcpy(newbuf,buf,buflen);
    delete[] buf;
    buf=newbuf;
  }    
  buf[buflen++]=c;
}

class Config {
  // The represented configuration:
  int Logaddrchange,Logbadpackets;
  char* Logfile;
  char* Daemonfile;
  char* Program;
  int Prgline;
  char* Pidfile;
  char* Filter;
  char* Netdev;
  int Maxcardc;
  int Counterc;  
  card_id_type Cit;
  char Counternames[maxcounterc][MaxCounterNameLen+1];
  
  // Proxy remapping:
  int Proxymaxcon; // Maximal concurrent proxy connections. 0 if proxy
                   // remapping is not selected.
  
  public:
  Config() : Logaddrchange(0), Logbadpackets(1), Logfile(0), Pidfile(0), Prgline(0),
             Daemonfile(0), Program(0), Counterc(0), Netdev(0), Filter(0), Maxcardc(1024),
	     Cit(idMAC), Proxymaxcon(0) 
	     {}
  ~Config() { delete[] Logfile; delete[] Program; delete[] Daemonfile; delete[] Netdev; delete[] Filter; }	     
  
  // Access functions for configurations:
  int logaddrchange() { return Logaddrchange;   }
  int logbadpackets() { return Logbadpackets; }
  card_id_type cit()  { return Cit;           }
  const char* logfile()     { return Logfile ? Logfile : DEFAULT_LOGFILE; }
  const char* daemonfile()  { return Daemonfile ? Daemonfile : DEFAULT_DAEMONFILE; }
  const char* pidfile()     { return Pidfile ? Pidfile : DEFAULT_PIDFILE; }

  char* program()     { return Program; }
  int prgline()       { return Prgline; } // The first line of the program
  char* filter()      { return Filter; }
  char* netdev()      { return Netdev; }
  int maxcardc()      { return Maxcardc; }
  int counterc()      { return Counterc; }  
  char* countername(int idx) { return Counternames[idx]; }
  int proxymaxcon()   { return Proxymaxcon;    }
  
  // Reads the configuration from a file - returns an error message or 0:
  char* readConfFile(char* filename);
};
