# This is a .spec file for creating Redhat Linux 5.2 or 6.0 .rpm and .srpm 
# files for the wipl program package.

Summary: Make statistics on basis of packets seen on a LAN.
Name: wipl
%define version 010530
Version: %{version}
Release: 1
Copyright: GNU
Group: Applications/Networking
Source: http://http://wipl-wrr.sourceforge.net/wipl/wipl-%{version}.src.tar.gz
BuildRoot: /var/tmp/wiplroot

%description
The wipl program package is able to maintain and display
statistics based on packets seen by a network card.
		
The program package contains a daemon which maintains the
statistics. For each packet seen by the network card the
daemon executes a small user supplied program. This program 
can update the statistics using information about the 
package. The program must be written in a very simple 
build-in programming language.

The program package also contains several client programs
which are able to retreview or modify the statistics 
maintained by the daemon. One of them is able to display 
tables with values evaluated from user supplied expressions
which can refer to the statistics maintained by the daemon. 
These tables can be written to HTML or XML files allowing
easy publication from web pages.

On the wipl home page an extension is available which makes it
possible for wipl to cooperate with proxyservers such as Squid 
and a socks5 server.

%prep

%setup

%build
make

%install
mkdir -p $RPM_BUILD_ROOT
make DIR_MAN=$RPM_BUILD_ROOT/%{_mandir} DIR_SBIN=$RPM_BUILD_ROOT/%{_sbindir} DIR_BIN=$RPM_BUILD_ROOT/%{_bindir} install
install -d -o 0 -g 0 $RPM_BUILD_ROOT/etc/rc.d/init.d $RPM_BUILD_ROOT/etc/logrotate.d
install -o 0 -g 0 redhat/wipld $RPM_BUILD_ROOT/etc/rc.d/init.d/wipld
install -m 644 -o 0 -g 0 redhat/logrotate $RPM_BUILD_ROOT/etc/logrotate.d/wipld
install -m 644 -o 0 -g 0 support/wipld.conf.default $RPM_BUILD_ROOT/etc/wipld.conf

%files
%{_sbindir}/wipld
%{_sbindir}/wiplcInetd
%{_bindir}/wiplc
%{_bindir}/wiplcSimple
%{_bindir}/wiplcExec
/etc/rc.d/init.d/wipld
/etc/logrotate.d/wipld
%{_mandir}/man1/wipl.1
%{_mandir}/man1/wiplc.1
%{_mandir}/man1/wiplcSimple.1
%{_mandir}/man1/wiplcExec.1
%{_mandir}/man5/wipllang.5
%{_mandir}/man8/wipld.8
%{_mandir}/man8/wiplcInetd.8
%config /etc/wipld.conf
%doc wipl.lsm
%doc HISTORY
%doc LICENSE
%doc README
%doc support
%doc wiplJava

%post 
chkconfig --add wipld

%preun
if [ -e /var/run/wipld.pid ]; then
  /etc/rc.d/init.d/wipld stop
fi
chkconfig --del wipld
  
%postun
rm -f /var/log/wipld.*
