#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <signal.h>
#define __USE_BSD
#include <unistd.h>
#include <pthread.h>
#include <sys/time.h>

#include "defs.h"

#define ALMOST_A_SECOND	990

struct timeval tv;
struct timezone tz;

typedef struct {
	logcore log;
	unsigned int time_updated;
	} cachecore;

typedef struct _node {
	logcore log;
	struct _node *next;
	} node;

cachecore cache[CACHESIZE];
node *packet_list;
int cachesem;				// Semaphore for accessing cache.
int movefilesem;			// Semaphore for moving file

int readfifo(void);
void packet_list_insert(logcore *);
void *date_check(void *);
void *clear_cache(void *);
void dump_packet(logcore *,FILE *);
void sighandler(int);

int readfifo(void) {
	FILE *f;
	char buf[512];	
	logcore le;
	for(int index=0;index<CACHESIZE;index++)
		cache[index].time_updated=0;
	cachesem=0;
	movefilesem=0;
	packet_list=NULL;

	
	f=fopen(LOG_FIFO,"r");
	while(1) {
		fscanf(f,"%s",buf);
		if(!strcmp(buf,"<6>Packet")) {
			fscanf(f,"%s",buf); 			// "log:"
			if(strcmp(buf,"log:")) { 
#ifdef PARANOIA_KERNEL_CHECK
			fprintf(stderr,"Malformed kernel output: instead of log: got %s\n",buf); 
#endif
			continue; 
			};
			fscanf(f,"%s",buf); 			// "input/output/forward"
#ifdef IGNORE_OUTPUT_MASQ
			int theo_is_opening_ultrapasswords_com=0;
			if(!strcmp(buf,"output")) theo_is_opening_ultrapasswords_com=1;
#endif
			fscanf(f,"%s",buf);				// "-"
			if(strcmp(buf,"-")&&strcmp(buf,"MASQ")) {
#ifdef PARANOIA_KERNEL_CHECK
			fprintf(stderr,"Malformed kernel output: instead of - got %s\n",buf); 
#endif
			continue; 
			};

			fscanf(f,"%s",buf);				// "eth0"
			fscanf(f,"%s",buf);				// "PROTO=1"
			if(buf[3]!='T') {
#ifdef PARANOIA_KERNEL_CHECK
			fprintf(stderr,"Malformed kernel output (PROTO)\n");
#endif	
			continue;
			};

			le.proto=atoi(buf+6);
			fscanf(f,"%s",buf);				// "193.0.0.193:0"
			le.srcip=0;
			le.sport=0;
			char *theo_the_green_elf=buf;
			char *the_super_token=strtok(theo_the_green_elf,".");
			if(the_super_token) 			// IP address byte 1
				le.srcip=atoi(the_super_token);
			else {							// Else complain, ofc. :)
#ifdef PARANOIA_KERNEL_CHECK
				fprintf(stderr,"Malformed 1 IP address or kernel output\n");
#endif	
				continue;
			};
			the_super_token=strtok(NULL,".");
			if(the_super_token)  			// IP address byte 2
				le.srcip+=atoi(the_super_token)<<8;
			else {							// Else complain, ofc. :)
#ifdef PARANOIA_KERNEL_CHECK
				fprintf(stderr,"Malformed 2 IP address or kernel output\n");
#endif	
				continue;
			};
			the_super_token=strtok(NULL,".");
			if(the_super_token)  			// IP address byte 3
				le.srcip+=(unsigned int)atoi(the_super_token)<<16;
			else {							// Else complain, ofc. :)
#ifdef PARANOIA_KERNEL_CHECK
				fprintf(stderr,"Malformed 3 IP address or kernel output\n");
#endif	
				continue;
			};
			the_super_token=strtok(NULL,".");
			char *a_new_super_token=strtok(the_super_token,":");
			if(a_new_super_token)  			// IP address byte 4
				le.srcip+=(unsigned int)atoi(a_new_super_token)<<24;
			else {							// Else complain, ofc. :)
#ifdef PARANOIA_KERNEL_CHECK
				fprintf(stderr,"Malformed 4 IP address or kernel output\n");
#endif	
				continue;
			};
			a_new_super_token=strtok(NULL,":");
			if(a_new_super_token)				// Source port ofc!
				le.sport=atoi(a_new_super_token);
			else {
#ifdef PARANOIA_KERNEL_CHECK
				fprintf(stderr,"Malformed IP address or port or kernel output or something. Not my fault! No! No!\n");
#endif	
				continue;
			};
#ifdef IGNORE_OUTPUT_MASQ
			if(le.sport>=61000&&theo_is_opening_ultrapasswords_com)
				continue;					// Dropped packet. *grins*
#endif
			fscanf(f,"%s",buf);				// "194.102.252.17:0"
			le.dstip=0;
			le.dport=0;
			theo_the_green_elf=buf;
			the_super_token=strtok(theo_the_green_elf,".");
			if(the_super_token) 			// IP address byte 1
				le.dstip=atoi(the_super_token);
			else {							// Else complain, ofc. :)
#ifdef PARANOIA_KERNEL_CHECK
				fprintf(stderr,"Malformed 1 IP address or kernel output\n");
#endif	
				continue;
			};
			the_super_token=strtok(NULL,".");
			if(the_super_token)  			// IP address byte 2
				le.dstip+=atoi(the_super_token)<<8;
			else {							// Else complain, ofc. :)
#ifdef PARANOIA_KERNEL_CHECK
				fprintf(stderr,"Malformed 2 IP address or kernel output\n");
#endif	
				continue;
			};
			the_super_token=strtok(NULL,".");
			if(the_super_token)  			// IP address byte 3
				le.dstip+=(unsigned int)atoi(the_super_token)<<16;
			else {							// Else complain, ofc. :)
#ifdef PARANOIA_KERNEL_CHECK
				fprintf(stderr,"Malformed 3 IP address or kernel output\n");
#endif	
				continue;
			};
			the_super_token=strtok(NULL,".");
			a_new_super_token=strtok(the_super_token,":");
			if(a_new_super_token)  			// IP address byte 4
				le.dstip+=(unsigned int)atoi(a_new_super_token)<<24;
			else {							// Else complain, ofc. :)
#ifdef PARANOIA_KERNEL_CHECK
				fprintf(stderr,"Malformed 4 IP address or kernel output\n");
#endif	
				continue;
			};
			a_new_super_token=strtok(NULL,":");
			if(a_new_super_token)				// Destination port ofc!
				le.dport=atoi(a_new_super_token);
			else {
#ifdef PARANOIA_KERNEL_CHECK
				fprintf(stderr,"Malformed IP address or port or kernel output or something. Not my fault! No! No!\n");
#endif	
				continue;
			};
			fscanf(f,"%s",buf);				// "L=84"
			le.len=atoi(buf+2);
			le.time=tv.tv_sec;
			fscanf(f,"%s",buf);				// "S=0x00"
			fscanf(f,"%s",buf);				// "I=39837"
			fscanf(f,"%s",buf);				// "F=0x0000"
			fscanf(f,"%s",buf);				// "T=243"
			fscanf(f,"%s",buf);				// "(#1)"

			// Ok, now we have a complete logcore entry  (and its name is le);
			// Let's check the cache. :)
	
			int found=0;
			int found_new_slot=-1;

			if(cachesem) {
#ifdef CACHE_CHECK
				printf("Someone's messing with the cache. \n");
#endif
				while(cachesem) ;		//See if someone else uses the cache ;)
			};
			cachesem=1;

			for(int index=0;index<CACHESIZE;index++) {
				if(cache[index].time_updated==0) {
					found_new_slot=index;
					continue;
					};
				if(memcmp( (void *)&cache[index].log, (void *)&le, 
					3*sizeof(unsigned int)+2*sizeof(unsigned short int)))
						continue;

				// Found entry in cache.		
#ifdef CACHE_CHECK
				printf("Found entry in cache.\n");
#endif
				
				cache[index].log.len+=le.len;
				cache[index].time_updated=le.time;
				found=1;
				break;
				};

			if(!found) if(found_new_slot>=0) {			// Insert entry into cache
#ifdef CACHE_CHECK
				printf("Inserting entry into cache.\n");
#endif
				memcpy((void *)&cache[found_new_slot].log,(void *)&le,sizeof(le));
				cache[found_new_slot].time_updated=le.time;
			} else {
				// Else we will insert the packet into a list
#ifdef CACHE_CHECK
				printf("Inserting packet into list.\n");
#endif
				packet_list_insert(&le);
				};

			cachesem=0;	
			};
		};
	};

void packet_list_insert(logcore *le) {
	if(packet_list) {
		node *a_packet_node=new node;
		if(!a_packet_node) {
			fprintf(stderr,"Could not malloc() 24 bytes for a packet entry.\n");
			return;
			};
		memcpy((void*)&a_packet_node->log,(void*)le,sizeof(logcore));
		a_packet_node->next=packet_list;
		packet_list=a_packet_node;
	} else {
		packet_list=new node;
		if(!packet_list) {
			fprintf(stderr,"Could not malloc() 24 bytes for a packet entry.\n");
			return;
			};
		memcpy((void*)&packet_list->log,(void*)le,sizeof(logcore));
		packet_list->next=NULL;
		};
	};

void *date_check(void *bogus_argument) {
	while(1) {
		gettimeofday(&tv,&tz);
		usleep(ALMOST_A_SECOND);
		};
	};


void dump_packet(logcore *le,FILE *f) {
	if(!fwrite((void *)le,sizeof(logcore),1,f)) {
		fprintf(stderr,"Could not write to dump file.\n");
		return;
		};
	};


void *clear_cache(void *bogus_argument) {
	while(1) {
		sleep(DUMP_TIMEOUT);

		// First check if the movefile semaphore is red :)
		if(movefilesem)	{		// Oops, it was, and we almost missed it. :)
			movefilesem=0;		// It wouldn't be the first red light anyway..
			sleep(MOVEFILE_SLEEP);
			};
		while(cachesem) ;		// Another thread is messing up with the cache
		cachesem=1;
		// Clear cache and that kind of stuff.
		// We have to dump 2 things: the packet list and the cache. :)	
		
		FILE *f;
		f=fopen(OUTPUT_FILE,"a");
		if(!f) {
			fprintf(stderr,"Could not open dump file.\n");
			return NULL;
			};
	
		// Here comes the packet list.	

		node *a_packet_node_martir_cristi;
		if(packet_list) dump_packet(&packet_list->log,f);
		int theo_is_watching_xpics=0;
		if(packet_list) {
			if(packet_list->next==NULL) theo_is_watching_xpics=1;
			while(packet_list->next) {
				a_packet_node_martir_cristi=packet_list;
				packet_list=packet_list->next;
				delete a_packet_node_martir_cristi;
				dump_packet(&packet_list->log,f);
				};
			if(theo_is_watching_xpics) 
				delete packet_list;
			};
		packet_list=NULL;

		// ..and here comes the cache. Simple, quick thus efficient.

		for(int index=0;index<CACHESIZE;index++) {
			if(cache[index].time_updated==0) continue;
			dump_packet(&cache[index].log,f);
			cache[index].time_updated=0;
			};

		// We want to close the file as well. :)
		fclose(f);
	
		// We're done with the cache.
		cachesem=0;
		};
	};

void sighandler(int sig) {

	switch(sig) {
		case SIGUSR1:
			movefilesem=1;
		// This will actually give the one who sent the signal 
		// at least MOVEFILE_SLEEP seconds to move the file 
		// (at most MOVEFILE_SLEEP+DUMP_TIMEOUT). Neat, eh?
			break;
		case SIGHUP:
		case SIGQUIT:
		case SIGINT:
			break;
		default:				
			;
		};

	};

int main(void) {
	pthread_t date_thread, log_thread;
	signal(SIGHUP,sighandler);
	signal(SIGQUIT,sighandler);
	signal(SIGINT,sighandler);
	signal(SIGUSR1,sighandler);
	if(pthread_create(&date_thread,NULL,&date_check,NULL)) {
		fprintf(stderr,"Could not create a new thread for date checking.\n");
		exit(1);
		};
	if(pthread_create(&log_thread,NULL,&clear_cache,NULL)) {
		fprintf(stderr,"Could not create a new thread for cache clearing.\n");
		exit(2);
		};
	return readfifo();
	};
