#ifndef __T_DEFS_H
#define __T_DEFS_H

// Defines:


#define IGNORE_OUTPUT_MASQ
// IGNORE_OUTPUT_MASQ means that packets passing throughout the
//   output chain that have port address >= 61000 (standard masq)
//   won't be logged. Reason: if you masq for a network, these packets
//   appear twice, once in the forward chain, and once in the output chain

// #define PARANOIA_KERNEL_CHECK
// This will print out various messages about klogd errors 
// (if the system becomes overloaded with messages klogd will
//  fail to print some of them right)

// #define CACHE_CHECK
// Silly debugging option. :)

#define LOG_FIFO    "/var/log/kernel"
// The file that will be used as pipe between klogd and tlog

#define CACHESIZE   40
// Why do we need the cache? Because:
// Suppose a packet comes from 10.0.0.1:10 to 10.0.0.2:20
// Then a lot more packets come from 10.0.0.1:10 to 10.0.0.2:20
// If so, only the size matters, and we add all packets into a 
//  single big one. :)
// Cache size = how many entries of such packets (the cache is flushed
//  every DUMP_TIMEOUT secs)

#define MOVEFILE_SLEEP  20
// If you send the program SIGUSR1, you have MOVEFILE_SLEEP seconds to 
// safely move/delete/write to the logfile

#define DUMP_TIMEOUT    10
// How often the program writes into the output file.

#define OUTPUT_FILE		"/root/acct.t"
// And finally, the output file itself. :)

// ---------- Shouldn't need to modify anything more. :)

typedef struct {
	unsigned int srcip,dstip,proto;
	unsigned short int sport,dport;
	unsigned int time,len;
	} logcore;

#endif
