/*
PPPtime version 0.9; prints out ppp connection time
    Copyright (C) 1999  Justin Azoff

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "./ppptime.h"
#include <iostream.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>

int main(int argc, char *argv[])
{
   if( argc==1 )
     {
	//no options given on cl
	mTime time;
	//time=GetTime();
	//DispTime(time);
	DispTime(GetTime());
	return 1;
     }

   for(int n=1;n<argc;n++)
     {
	//cout <<argv[n]<<endl;
	if(!strcmp(argv[n], "-h")  || !strcmp(argv[n], "--help"))
	  {
	     Usage();
	     break;
	  }

	else if(!strcmp(argv[n], "-V") || !strcmp(argv[n], "--version"))
	  cout << "PPPtime Version "<< VERSION<<endl;

	else if(!strcmp(argv[n], "-w") || !strcmp(argv[n], "--watch"))
	  {
	     n++;
	     if(argv[n])
	       Watch(atof(argv[n]));
	     else
	       Watch(1);
	  }

     }

   return 0;
}

mTime GetTime()
  //preconditions:none
{
   mTime t;
   long starttime;
   long currenttime;
   int time_online;
   currenttime=time(0);
   if (!stat(STAMP_FILE, &st))
     {
	starttime=st.st_mtime;
	//cout <<starttime;
	time_online=currenttime-starttime-6;
	//cout <<time_online<<endl;
	//time_online/=60;
	t.hour= (time_online/60)/60%100;
	t.minute=time_online/60%60;
	t.secs=  time_online%60;
     }
   else
     t.hour=-1;
   return t;
   //postcondition: Using stat, returns the time is hours, mins, and secs if conneted;
   //-1 otherwise
}

void DispTime(mTime t)
{
   if (t.hour <0)
     {
	cout <<"ERROR, Not connected"<<endl;
	return;
     }
   if (t.hour ==0)
     cout <<"Online for " <<t.minute<< " minutes and "<<t.secs<< " seconds"<<endl;
   else if (t.hour ==1)
     cout <<"Online for 1 hour " << t.minute << " minutes and "<<t.secs<< " seconds"<<endl;
   else
     cout <<"Online for "<< t.hour << " hours "<< t.minute << " minutes and "<<t.secs<< " seconds"<<endl;
}

void Watch(double delay)
  //Precondition delay is the option after -w on the command line
  //if no time was given this is 1
{

   if (delay==0)
     delay=1;
   for(;;)
     {
//	cout <<endl<<delay<<endl;
	DispTime(GetTime());
	usleep(int(1000000*delay));
     }

}

void Usage()
{
   cout << "ppptime prints out the ppp connection time" <<endl;
   cout << "Usage: ppptime [-h|--help] [-w|--watch {delay}] [-V|--version]" <<endl;
}
