/*
   Header file for Internet protocol headers
   --------------------------------------------------------------------
   Perro - The Internet Protocols logger

   Copyright (C) 1998, 1999, 2000 Diego Javier Grigna <diego@grigna.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * If "unsigned char, unsigned short and unsigned long" doesn't have the
 * sizes "8, 16 and 32 bits" in your platform, then you could change it here.
 */
#define PERRO_U8   unsigned char  /* Unsigned 8  bits on ix86 */
#define PERRO_U16  unsigned short /* Unsigned 16 bits on ix86 */
#define PERRO_U32  unsigned long  /* Unsigned 32 bits on ix86 */

/*
 * IP header
 * RFC 791
 */

struct perro_iphdr {
       PERRO_U8  hlv;              /* IP header length + IP version */
       PERRO_U8  tos;              /* Type of service              */
       PERRO_U16 tot_len;          /* Total length of packet       */
       PERRO_U16 id;               /* Identification               */
       PERRO_U16 frag_off;         /* Fragmentation flags & offset */
       PERRO_U8  ttl;              /* Time To Live                 */
       PERRO_U8  protocol;         /* Protocol                     */
       PERRO_U16 check;            /* Checksum                     */
       PERRO_U32 saddr;            /* Source address               */
       PERRO_U32 daddr;            /* Destination address          */
};

/* TCP flags masks */

#define PERRO_TH_URG  0x20
#define PERRO_TH_ACK  0x10
#define PERRO_TH_PSH  0x08
#define PERRO_TH_RST  0x04
#define PERRO_TH_SYN  0x02
#define PERRO_TH_FIN  0x01

/*
 * TCP header
 * RFC 793
 */

struct perro_tcphdr {
       PERRO_U16 th_sport;  /* Source port            */
       PERRO_U16 th_dport;  /* Destination port       */
       PERRO_U32 th_seq;    /* Sequence number        */
       PERRO_U32 th_ack;    /* Acknowledgement number */
       PERRO_U8  th_do;     /* Data offset + reserved */
       PERRO_U8  th_flags;  /* Flags                  */
       PERRO_U16 th_win;    /* Window size            */
       PERRO_U16 th_sum;    /* Checksum               */
       PERRO_U16 th_urp;    /* Urgent pointer         */
};


/*
 * UDP header
 * RFC 768
 */

struct perro_udphdr {
       PERRO_U16 source;
       PERRO_U16 dest;
       PERRO_U16 len;
       PERRO_U16 check;
};


/*
 * ICMP header
 * RFC 792
 */

struct perro_icmphdr {
  PERRO_U8  type;
  PERRO_U8  code;
  PERRO_U16 checksum;
  union {
        struct {
                PERRO_U16 id;
                PERRO_U16 sequence;
        } echo;
        PERRO_U32 gateway;
        PERRO_U32 unused;
        PERRO_U32 reserved;
        PERRO_U32 routad;  /* Router advertisement fields */
        PERRO_U8 pointer;  /* For parameter problem */
  } un;
};

