/* konserver (C) 1998 Christoph Neerfeld <Christoph.Neerfeld@home.ivm.de> */
/* Database definition for user database */

database konline
{
	data file "users.dat" contains users;
	key  file [1024] "users.ix1" contains users.user_id;
	key  file [1024] "users.ix2" contains users.name;
	key  file [1024] "users.ix3" contains users.nick;
	key  file [1024] "users.ix4" contains users.email;
	data file "message.dat" contains message;
	key  file [1024] "message.ix1" contains message.msg_id;
	key  file [1024] "message.ix2" contains message.recv_id;
	data file "watch.dat" contains watch;
	key  file [1024] "watch.ix1" contains watch.watch_key;
	key  file [1024] "watch.ix2" contains watch.wuser_id;
	key  file [1024] "watch.ix3" contains watch.watch_id;

	record users
	  {
	     unsigned long user_id;
	     char  name[41];
	     char  vname[41];
	     char  nick[21];
	     char  date[16];   	/* YYYYMMDDhhmm+TZ */
	     char  email[81];
             char  passwd[11];

	     primary key user_id;
	     alternate key name;
	     alternate key nick;
	     alternate unique key email;
	  }

	record message
	  {
	     short msg_id;
	     unsigned long  send_id;
	     unsigned long  recv_id;
	     char  msg[256];
	     char  date[16];   	/* YYYYMMDDhhmm+TZ */

	     primary key msg_id;
	     alternate key recv_id;
	  }

	record watch
	  {
	     unsigned long wuser_id;   	/* id of owner */
	     unsigned long watch_id;	/* id to watch for */

	     primary key watch_key { wuser_id, watch_id };
	     alternate key wuser_id;
	     alternate key watch_id;
	  }

	sequence uuser_id 0 by 1; /* unique user id */
	sequence umsg_id 0 by 1; /* unique message id */
}
