// -*- C++ -*-
//
//  PipeCom
//
//  Copyright (C) 1998 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

/*****************************************************

  member functions of: class PipeCom

  class for interprocess communication with sockets.

  used in: 

  ***************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "PipeCom.h"

extern "C" {
#include <sys/types.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include <fcntl.h>
}

#define ERR cerr
#include <fstream.h>
//extern ofstream errlog;

extern int debug;

#define TIMEOUT 5

PipeCom::PipeCom (int fd_in /*, int fd_out, LrdsError *err*/ ) 
{
  for(int i = 0; i < 1024; i++)
    ibuf[i] = 0;
  for(int i = 0; i < 1024; i++)
    obuf[i] = 0;
  input = fd_in; 
  output = fd_in; // this version is for sockets which are bidirectional
  ipos = 2;
  opos = 2;
  /*l_error = err;*/ 
}

int PipeCom::setBlocking( int fd, short set )
{
  int oldflags = fcntl( fd, F_GETFL, 0 );
  if( oldflags < 0 )
    return oldflags;
  if( set )
    oldflags |= O_NONBLOCK;
  else
    oldflags &= ~O_NONBLOCK;
  return fcntl( fd, F_SETFL, oldflags );
}

int PipeCom::send()
{
  short bytes_written = 0;
  short last_written = 0;
  int retcode;
  fd_set out_set;
  struct timeval timeout;
  timeout.tv_sec = TIMEOUT;
  timeout.tv_usec = 0;
  
  if( debug )
    ERR << "Sending: ";
  short len = opos-sizeof(short);
  len = htons(len);
  obuf[0] = *((char *) &len);
  obuf[1] = *(((char *) &len)+1);
  
  if( setBlocking( output, 1 ) < 0 )
    {
      ERR << "PipeCom--WARNING: can't set nonblocking mode" << endl;
      //return -1;
    }
  while( bytes_written < opos )
    {
      do {
	FD_ZERO(&out_set);
	FD_SET(output, &out_set);
	errno = 0;
	retcode = select( FD_SETSIZE, 0, &out_set, 0, &timeout );
      } while( errno == EINTR );
      if( retcode > 0 )
	{
	  do {
	    errno = 0;
	    if( (last_written = write (output, obuf+bytes_written, opos-bytes_written)) < 0 )
	      perror("PipeCom::send: ");
	  } while( errno == EINTR );
	}
      else
	{
	  if( retcode == 0 && debug )
	    ERR << "PipeCom:RECV  TIMEOUT" << endl;
	  setBlocking( output, 0 );
	  return -1;  // unrecoverable error or timeout
	}
      if( errno == EPIPE )
	{
	  setBlocking( output, 0 );
	  return -1;
	}
      bytes_written += last_written;
      //ERR << bytes_written << " bytes written" << endl;
    }
  for(int i = 0; i < opos; i++)
    {
      if( debug )
      	ERR << (int) obuf[i] << ','; // *****************TESTING ONLY
      obuf[i] = 0;
    }
  if( debug )
    ERR << endl;
  opos = 2;
  //ERR << "leaving send" << endl;
  setBlocking( output, 0 );
  return 0;
}

int PipeCom::recv()
{
  short bytes_read = 0;
  short last_read = 0;
  int retcode;
  fd_set in_set;
  struct timeval timeout;

  if( debug )
    ERR << "entered PipeCom:RECV" << endl;
  short len = 0;
  for ( int i = 0; i < ipos; i++)
    {
      ibuf[i] = 0;
    }
  ipos = 2;
  while( bytes_read < LL_SHORT )
    {
      timeout.tv_sec = TIMEOUT;
      timeout.tv_usec = 0;
      do {
	FD_ZERO(&in_set);
	FD_SET(input, &in_set);
	errno = 0;
	retcode = select( FD_SETSIZE, &in_set, 0, 0, &timeout );
      } while( errno == EINTR );
      if( retcode > 0 )
	{
	  do {
	    errno = 0;
	    last_read = read (input, ibuf+bytes_read, LL_SHORT-bytes_read);
	  } while( errno == EINTR );
	  if( last_read == 0 )
	    { // end of file; connection has been closed
	      return -1;
	    }
	}
      else
	{
	  if( retcode == 0 && debug)
	    ERR << "PipeCom:RECV  TIMEOUT" << endl;
	  return -1;  // unrecoverable error or timeout
	}
      bytes_read += last_read;
    }
  *((char *) &len) = ibuf[0];
  *(((char *) &len)+1) = ibuf[1];
  len = ntohs(len);
  bytes_read = last_read = 0;
  while( bytes_read < len )
    {
      timeout.tv_sec = TIMEOUT;
      timeout.tv_usec = 0;
      do {
	FD_ZERO(&in_set);
	FD_SET(input, &in_set);
	errno = 0;
	retcode = select( FD_SETSIZE, &in_set, 0, 0, &timeout );
      } while( errno == EINTR );
      if( retcode > 0 )
	{
	  do {
	    errno = 0;
	    last_read = read (input, ibuf+LL_SHORT+bytes_read, len-bytes_read);
	  } while( errno == EINTR );
	  if( last_read == 0 )
	    { // end of file; connection has been closed
	      return -1;
	    }
	}
      else
	{
	  if( retcode == 0 && debug )
	    ERR << "PipeCom:RECV  TIMEOUT" << endl;
	  return -1;  // unrecoverable error or timeout
	}
      bytes_read += last_read;
    }
  return len;
}




