/**
 * $Id: kimon.h,v 1.2 1998/05/13 09:37:33 dahlweid Exp $
 *
 * Markus Dahlweid (dahlweid@informatik.uni-bremen.de)
 *
 */

#ifndef _IsdnMon_H_
#define _IsdnMon_H_

#include <sys/time.h>
#include <stdio.h>
#include <linux/isdn.h>
#include <qbrush.h>
#include <qlabel.h>
#include <qlined.h>
#include <qdatetm.h>
#include <kpopmenu.h>
#include <kconfig.h>
#include <kcolorbtn.h>

#define		PATH_ISDNINFO	"/dev/isdninfo"
#define		IM_BUFSIZE	10 + (22 * ISDN_MAX_CHANNELS)
#define		IM_VERSION	"0.5"
#define         KIMON_VERSION   "Version 0.2.3"

extern KConfig *kimonConf;

class KIsdnInfoLineStatus : public QFrame {
    Q_OBJECT
public:
    KIsdnInfoLineStatus(QWidget *parent=0);
    ~KIsdnInfoLineStatus();
    
public slots:
    void set_phone(const char *);

protected:
    virtual void mouseReleaseEvent (QMouseEvent *);

private:
    char *number;
};


class KIsdnInfoLine : public QWidget
{
    Q_OBJECT
public:
    KIsdnInfoLine(QWidget *parent = 0, bool panel=true, const char *name = 0);
    ~KIsdnInfoLine();

public slots:
    void set_id(int);
    void set_phone(char*);
    void set_usage(char*);
    void set_status(char*);
    void set_channel(char*);
    void set_online(int);
    void set_time(char*);
    void reset_time();
    void recalc_time();
    
protected:
    QLabel *_id;
    QLabel *_phone;
    QLabel *_usage;
    QLabel *_status;
    QLabel *_channel;
    QLabel *_time;
    
    QColor *green;
    QColor *red;
    QColor *blue;
    
    QDateTime _upsince;
    int dur, sec, min, hou;
    char timestr[12];
    
    KIsdnInfoLineStatus *_online;

    int _onl;
    bool _panel;
};


class KIsdnInfo : public QWidget
{
    Q_OBJECT
public:
    KIsdnInfo(int num, QWidget *parent = 0, const char *name = 0);
    ~KIsdnInfo();

public slots:
    void set_id(int, int);
    void set_phone(int, char*);
    void set_usage(int, char*);
    void set_status(int, char*);
    void set_channel(int, char*);
    void set_online(int, int);
    void reset_time(int);
    void recalc_time(int);
    
protected:
    KIsdnInfoLine *info[ISDN_MAX_CHANNELS];
    int lines;
};


class KIsdnPathPrefs : public QWidget
{
    Q_OBJECT
public:
    KIsdnPathPrefs(QWidget *parent = 0, const char *name = 0);
    ~KIsdnPathPrefs();
	
public slots:
    void readValues();
    void saveValues();
    
private:
    QLineEdit *ISDNinfo;
    QLineEdit *ISDNcontrol;
    QLineEdit *MiddleClick;
    QComboBox *OpenOnCall;
};


class KIsdnColorPrefs : public QWidget
{
    Q_OBJECT
public:
    KIsdnColorPrefs(QWidget *parent = 0, const char *name = 0);
    ~KIsdnColorPrefs();

public slots:
    void readValues();
    void saveValues();
    
private:
    KColorButton *black;
    KColorButton *red;
    KColorButton *blue;
    KColorButton *green;
};


class KIsdnMon : public QWidget
{
    Q_OBJECT
public:
    KIsdnMon (QWidget *parent = 0, const char *name = 0, WFlags f=0);
    ~KIsdnMon ();
    void updateValues();
 
public slots:
    void open();
    void quit();
    void prefs();

protected slots:
    void parseConfig();
    
protected:
    virtual void mouseReleaseEvent (QMouseEvent *);
    virtual void mouseDoubleClickEvent (QMouseEvent *);
    virtual void timerEvent(QTimerEvent *);
    virtual void paintEvent(QPaintEvent *);
    
    void copyUsage();
    int compareUsage();
    
    void readInfo();
    int num_isdn_lines();
    
    int tid;
    unsigned timer_interval;
    QBrush brush[4];

    KIsdnInfo *IInfo;
    
    FILE *isdninfo;
    char buf[IM_BUFSIZE];
    
    char *idmap[ISDN_MAX_CHANNELS];
    int chmap[ISDN_MAX_CHANNELS];
    int drmap[ISDN_MAX_CHANNELS];
    int usage[ISDN_MAX_CHANNELS];
    int compare[ISDN_MAX_CHANNELS];
    int flags[ISDN_MAX_DRIVERS];
    char *phone[ISDN_MAX_CHANNELS];
    
    int i, lines;

    KPopupMenu *_menu;
    QString ISDNinfo, MiddleClick;
    QColor black, green, red, blue;
    int openOnChange;
};

#endif
