
/***

fltmgr.c - filter list management routines

Copyright (c) Gerard Paul Java 1998

This software is open source; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License in the included COPYING file for
details.

***/

#include <curses.h>
#include <panel.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "attrs.h"
#include "deskman.h"
#include "input.h"
#include "dirs.h"
#include "utfdefs.h"
#include "utfilter.h"

int loadfilterlist(unsigned int protocol, struct ffnode **fltfile)
{
    int pfd;
    int result = 0;

    struct ffnode *ffiles = NULL;
    struct ffnode *ptemp;
    struct ffnode *tail = NULL;

    int br;

    if (protocol == F_TCP)
	pfd = open(TCPFLNAME, O_RDONLY);
    else
	pfd = open(UDPFLNAME, O_RDONLY);

    if (pfd < 0) {
	*fltfile = NULL;
	return 1;
    }
    do {
	ptemp = malloc(sizeof(struct ffnode));
	br = read(pfd, &(ptemp->ffe), sizeof(struct filterfileent));

	if (br > 0) {
	    if (ffiles == NULL) {
		ffiles = ptemp;
		ffiles->prev_entry = NULL;
	    } else {
		tail->next_entry = ptemp;
		ptemp->prev_entry = tail;
	    }

	    ptemp->next_entry = NULL;
	    tail = ptemp;
	} else {
	    free(ptemp);

	    if (br < 0)
		result = 1;
	}
    } while (br > 0);

    close(pfd);
    *fltfile = ffiles;

    if (ffiles == NULL)
	result = 1;

    return result;
}

void destroyfilterlist(struct ffnode *fltlist)
{
    struct ffnode *fftemp;

    if (fltlist != NULL) {
	fftemp = fltlist->next_entry;

	do {
	    free(fltlist);
	    fltlist = fftemp;
	    if (fftemp != NULL)
		fftemp = fftemp->next_entry;
	} while (fltlist != NULL);
    }
}

void save_filterlist(unsigned int protocol, struct ffnode *fltlist)
{
    struct ffnode *fltfile;
    struct ffnode *ffntemp;
    int fd;
    int bw;

    if (protocol == F_TCP)
	fd =
	    open(TCPFLNAME, O_WRONLY | O_CREAT | O_TRUNC,
		 S_IRUSR | S_IWUSR);
    else
	fd =
	    open(UDPFLNAME, O_WRONLY | O_CREAT | O_TRUNC,
		 S_IRUSR | S_IWUSR);

    if (fd < 0) {
	listfileerr(2);
	clear_flt_tag(protocol);
	return;
    }
    fltfile = fltlist;
    while (fltfile != NULL) {
	bw = write(fd, &(fltfile->ffe), sizeof(struct filterfileent));

	if (bw < 0) {
	    listfileerr(2);
	    clear_flt_tag(protocol);
	    return;
	}
	ffntemp = fltfile;
	fltfile = fltfile->next_entry;
	free(ffntemp);
    }

    close(fd);
}

void get_filter_description(char *description, int *aborted,
			    char *pre_edit)
{
    struct FIELDLIST descfield;
    int dlgwintop;
    WINDOW *dlgwin;
    PANEL *dlgpanel;

    dlgwintop = (LINES - 9) / 2;
    dlgwin = newwin(7, 42, dlgwintop, (COLS - 42) / 2 - 10);
    dlgpanel = new_panel(dlgwin);
    wattrset(dlgwin, BOXATTR);
    colorwin(dlgwin);
    box(dlgwin, ACS_VLINE, ACS_HLINE);
    wattrset(dlgwin, STDATTR);
    wmove(dlgwin, 2, 2);
    wprintw(dlgwin, "Enter a description for this filter");
    wmove(dlgwin, 5, 2);
    stdkeyhelp(dlgwin);
    update_panels();
    doupdate();

    initfields(&descfield, 1, 35, dlgwintop + 3, (COLS - 42) / 2 - 8);
    addfield(&descfield, 33, 0, 0, pre_edit);
    fillfields(&descfield, aborted);
    strcpy(description, descfield.list->buf);
    destroyfields(&descfield);
    del_panel(dlgpanel);
    delwin(dlgwin);
    update_panels();
    doupdate();
}
